// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class ListSchemasRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
     */
    val clusterIdentifier: String? = builder.clusterIdentifier
    /**
     * A database name. The connected database is specified when you connect with your authentication credentials.
     */
    val connectedDatabase: String? = builder.connectedDatabase
    /**
     * The name of the database that contains the schemas to list.
     * If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
     */
    val database: String? = builder.database
    /**
     * The database user name. This parameter is required when authenticating using temporary credentials.
     */
    val dbUser: String? = builder.dbUser
    /**
     * The maximum number of schemas to return in the response.
     * If more schemas exist than fit in one response, then NextToken is returned to page through the results.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
     */
    val nextToken: String? = builder.nextToken
    /**
     * A pattern to filter results by schema name. Within a schema pattern, "%" means match any
     * substring of 0 or more characters and "_" means match any one character. Only schema name
     * entries matching the search pattern are returned.
     */
    val schemaPattern: String? = builder.schemaPattern
    /**
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
     */
    val secretArn: String? = builder.secretArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListSchemasRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListSchemasRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("connectedDatabase=$connectedDatabase,")
        append("database=$database,")
        append("dbUser=$dbUser,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("schemaPattern=$schemaPattern,")
        append("secretArn=$secretArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (connectedDatabase?.hashCode() ?: 0)
        result = 31 * result + (database?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (schemaPattern?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListSchemasRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (connectedDatabase != other.connectedDatabase) return false
        if (database != other.database) return false
        if (dbUser != other.dbUser) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (schemaPattern != other.schemaPattern) return false
        if (secretArn != other.secretArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListSchemasRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListSchemasRequest
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        fun clusterIdentifier(clusterIdentifier: String): FluentBuilder
        /**
         * A database name. The connected database is specified when you connect with your authentication credentials.
         */
        fun connectedDatabase(connectedDatabase: String): FluentBuilder
        /**
         * The name of the database that contains the schemas to list.
         * If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
         */
        fun database(database: String): FluentBuilder
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        fun dbUser(dbUser: String): FluentBuilder
        /**
         * The maximum number of schemas to return in the response.
         * If more schemas exist than fit in one response, then NextToken is returned to page through the results.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * A pattern to filter results by schema name. Within a schema pattern, "%" means match any
         * substring of 0 or more characters and "_" means match any one character. Only schema name
         * entries matching the search pattern are returned.
         */
        fun schemaPattern(schemaPattern: String): FluentBuilder
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        fun secretArn(secretArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary credentials.
         */
        var clusterIdentifier: String?
        /**
         * A database name. The connected database is specified when you connect with your authentication credentials.
         */
        var connectedDatabase: String?
        /**
         * The name of the database that contains the schemas to list.
         * If ConnectedDatabase is not specified, this is also the database to connect to with your authentication credentials.
         */
        var database: String?
        /**
         * The database user name. This parameter is required when authenticating using temporary credentials.
         */
        var dbUser: String?
        /**
         * The maximum number of schemas to return in the response.
         * If more schemas exist than fit in one response, then NextToken is returned to page through the results.
         */
        var maxResults: Int
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        var nextToken: String?
        /**
         * A pattern to filter results by schema name. Within a schema pattern, "%" means match any
         * substring of 0 or more characters and "_" means match any one character. Only schema name
         * entries matching the search pattern are returned.
         */
        var schemaPattern: String?
        /**
         * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating using Secrets Manager.
         */
        var secretArn: String?

        fun build(): ListSchemasRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clusterIdentifier: String? = null
        override var connectedDatabase: String? = null
        override var database: String? = null
        override var dbUser: String? = null
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var schemaPattern: String? = null
        override var secretArn: String? = null

        constructor(x: ListSchemasRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.connectedDatabase = x.connectedDatabase
            this.database = x.database
            this.dbUser = x.dbUser
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.schemaPattern = x.schemaPattern
            this.secretArn = x.secretArn
        }

        override fun build(): ListSchemasRequest = ListSchemasRequest(this)
        override fun clusterIdentifier(clusterIdentifier: String): FluentBuilder = apply { this.clusterIdentifier = clusterIdentifier }
        override fun connectedDatabase(connectedDatabase: String): FluentBuilder = apply { this.connectedDatabase = connectedDatabase }
        override fun database(database: String): FluentBuilder = apply { this.database = database }
        override fun dbUser(dbUser: String): FluentBuilder = apply { this.dbUser = dbUser }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun schemaPattern(schemaPattern: String): FluentBuilder = apply { this.schemaPattern = schemaPattern }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
    }
}
