// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



class ListStatementsRequest private constructor(builder: BuilderImpl) {
    /**
     * The maximum number of SQL statements to return in the response.
     * If more SQL statements exist than fit in one response, then NextToken is returned to page through the results.
     */
    val maxResults: Int = builder.maxResults
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
     */
    val nextToken: String? = builder.nextToken
    /**
     * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned.
     * If false, only statements run by the caller's IAM role in the current IAM session are returned.  The default is true.
     */
    val roleLevel: Boolean? = builder.roleLevel
    /**
     * The name of the SQL statement specified as input to BatchExecuteStatement or ExecuteStatement to identify the query.
     * You can list multiple statements by providing a prefix that matches the beginning of the statement name.
     * For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of myStatement.
     * Data API does a case-sensitive match of SQL statement names to the prefix value you provide.
     */
    val statementName: String? = builder.statementName
    /**
     * The status of the SQL statement to list. Status values are defined as follows:
     * ABORTED - The query run was stopped by the user.
     * ALL -  A status value that includes all query statuses. This value can be used to filter results.
     * FAILED - The query run failed.
     * FINISHED - The query has finished running.
     * PICKED - The query has been chosen to be run.
     * STARTED - The query run has started.
     * SUBMITTED - The query was submitted, but not yet processed.
     */
    val status: StatusString? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListStatementsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListStatementsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("roleLevel=$roleLevel,")
        append("statementName=$statementName,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (roleLevel?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListStatementsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (roleLevel != other.roleLevel) return false
        if (statementName != other.statementName) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListStatementsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListStatementsRequest
        /**
         * The maximum number of SQL statements to return in the response.
         * If more SQL statements exist than fit in one response, then NextToken is returned to page through the results.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned.
         * If false, only statements run by the caller's IAM role in the current IAM session are returned.  The default is true.
         */
        fun roleLevel(roleLevel: Boolean): FluentBuilder
        /**
         * The name of the SQL statement specified as input to BatchExecuteStatement or ExecuteStatement to identify the query.
         * You can list multiple statements by providing a prefix that matches the beginning of the statement name.
         * For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of myStatement.
         * Data API does a case-sensitive match of SQL statement names to the prefix value you provide.
         */
        fun statementName(statementName: String): FluentBuilder
        /**
         * The status of the SQL statement to list. Status values are defined as follows:
         * ABORTED - The query run was stopped by the user.
         * ALL -  A status value that includes all query statuses. This value can be used to filter results.
         * FAILED - The query run failed.
         * FINISHED - The query has finished running.
         * PICKED - The query has been chosen to be run.
         * STARTED - The query run has started.
         * SUBMITTED - The query was submitted, but not yet processed.
         */
        fun status(status: StatusString): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The maximum number of SQL statements to return in the response.
         * If more SQL statements exist than fit in one response, then NextToken is returned to page through the results.
         */
        var maxResults: Int
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response records have been retrieved for the request.
         */
        var nextToken: String?
        /**
         * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM role are returned.
         * If false, only statements run by the caller's IAM role in the current IAM session are returned.  The default is true.
         */
        var roleLevel: Boolean?
        /**
         * The name of the SQL statement specified as input to BatchExecuteStatement or ExecuteStatement to identify the query.
         * You can list multiple statements by providing a prefix that matches the beginning of the statement name.
         * For example, to list myStatement1, myStatement2, myStatement3, and so on, then provide the a value of myStatement.
         * Data API does a case-sensitive match of SQL statement names to the prefix value you provide.
         */
        var statementName: String?
        /**
         * The status of the SQL statement to list. Status values are defined as follows:
         * ABORTED - The query run was stopped by the user.
         * ALL -  A status value that includes all query statuses. This value can be used to filter results.
         * FAILED - The query run failed.
         * FINISHED - The query has finished running.
         * PICKED - The query has been chosen to be run.
         * STARTED - The query run has started.
         * SUBMITTED - The query was submitted, but not yet processed.
         */
        var status: StatusString?

        fun build(): ListStatementsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var maxResults: Int = 0
        override var nextToken: String? = null
        override var roleLevel: Boolean? = null
        override var statementName: String? = null
        override var status: StatusString? = null

        constructor(x: ListStatementsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.roleLevel = x.roleLevel
            this.statementName = x.statementName
            this.status = x.status
        }

        override fun build(): ListStatementsRequest = ListStatementsRequest(this)
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun roleLevel(roleLevel: Boolean): FluentBuilder = apply { this.roleLevel = roleLevel }
        override fun statementName(statementName: String): FluentBuilder = apply { this.statementName = statementName }
        override fun status(status: StatusString): FluentBuilder = apply { this.status = status }
    }
}
