// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model



/**
 * A parameter used in a SQL statement.
 */
class SqlParameter private constructor(builder: BuilderImpl) {
    /**
     * The name of the parameter.
     */
    val name: String? = builder.name
    /**
     * The value of the parameter.
     * Amazon Redshift implicitly converts to the proper data type. For more inforation, see
     * <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types in the
     * Amazon Redshift Database Developer Guide.
     */
    val value: String? = builder.value

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SqlParameter = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SqlParameter(")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SqlParameter

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SqlParameter = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SqlParameter
        /**
         * The name of the parameter.
         */
        fun name(name: String): FluentBuilder
        /**
         * The value of the parameter.
         * Amazon Redshift implicitly converts to the proper data type. For more inforation, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types in the
         * Amazon Redshift Database Developer Guide.
         */
        fun value(value: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the parameter.
         */
        var name: String?
        /**
         * The value of the parameter.
         * Amazon Redshift implicitly converts to the proper data type. For more inforation, see
         * <a href="https://docs.aws.amazon.com/redshift/latest/dg/c_Supported_data_types.html">Data types in the
         * Amazon Redshift Database Developer Guide.
         */
        var value: String?

        fun build(): SqlParameter
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var value: String? = null

        constructor(x: SqlParameter) : this() {
            this.name = x.name
            this.value = x.value
        }

        override fun build(): SqlParameter = SqlParameter(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun value(value: String): FluentBuilder = apply { this.value = value }
    }
}
