// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The SQL statement to run.
 */
class StatementData private constructor(builder: BuilderImpl) {
    /**
     * The date and time (UTC) the statement was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
     */
    val id: String? = builder.id
    /**
     * A value that indicates whether the statement is a batch query request.
     */
    val isBatchStatement: Boolean? = builder.isBatchStatement
    /**
     * The parameters used in a SQL statement.
     */
    val queryParameters: List<SqlParameter>? = builder.queryParameters
    /**
     * The SQL statement.
     */
    val queryString: String? = builder.queryString
    /**
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.
     */
    val queryStrings: List<String>? = builder.queryStrings
    /**
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    val secretArn: String? = builder.secretArn
    /**
     * The name of the SQL statement.
     */
    val statementName: String? = builder.statementName
    /**
     * The status of the SQL statement. An
     * example is the that the SQL statement finished.
     */
    val status: StatusString? = builder.status
    /**
     * The date and time (UTC) that the statement metadata was last updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StatementData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StatementData(")
        append("createdAt=$createdAt,")
        append("id=$id,")
        append("isBatchStatement=$isBatchStatement,")
        append("queryParameters=$queryParameters,")
        append("queryString=$queryString,")
        append("queryStrings=$queryStrings,")
        append("secretArn=$secretArn,")
        append("statementName=$statementName,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (isBatchStatement?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (queryStrings?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (statementName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StatementData

        if (createdAt != other.createdAt) return false
        if (id != other.id) return false
        if (isBatchStatement != other.isBatchStatement) return false
        if (queryParameters != other.queryParameters) return false
        if (queryString != other.queryString) return false
        if (queryStrings != other.queryStrings) return false
        if (secretArn != other.secretArn) return false
        if (statementName != other.statementName) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StatementData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StatementData
        /**
         * The date and time (UTC) the statement was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        fun id(id: String): FluentBuilder
        /**
         * A value that indicates whether the statement is a batch query request.
         */
        fun isBatchStatement(isBatchStatement: Boolean): FluentBuilder
        /**
         * The parameters used in a SQL statement.
         */
        fun queryParameters(queryParameters: List<SqlParameter>): FluentBuilder
        /**
         * The SQL statement.
         */
        fun queryString(queryString: String): FluentBuilder
        /**
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.
         */
        fun queryStrings(queryStrings: List<String>): FluentBuilder
        /**
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         */
        fun secretArn(secretArn: String): FluentBuilder
        /**
         * The name of the SQL statement.
         */
        fun statementName(statementName: String): FluentBuilder
        /**
         * The status of the SQL statement. An
         * example is the that the SQL statement finished.
         */
        fun status(status: StatusString): FluentBuilder
        /**
         * The date and time (UTC) that the statement metadata was last updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time (UTC) the statement was created.
         */
        var createdAt: Instant?
        /**
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        var id: String?
        /**
         * A value that indicates whether the statement is a batch query request.
         */
        var isBatchStatement: Boolean?
        /**
         * The parameters used in a SQL statement.
         */
        var queryParameters: List<SqlParameter>?
        /**
         * The SQL statement.
         */
        var queryString: String?
        /**
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query request.
         */
        var queryStrings: List<String>?
        /**
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         */
        var secretArn: String?
        /**
         * The name of the SQL statement.
         */
        var statementName: String?
        /**
         * The status of the SQL statement. An
         * example is the that the SQL statement finished.
         */
        var status: StatusString?
        /**
         * The date and time (UTC) that the statement metadata was last updated.
         */
        var updatedAt: Instant?

        fun build(): StatementData
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdAt: Instant? = null
        override var id: String? = null
        override var isBatchStatement: Boolean? = null
        override var queryParameters: List<SqlParameter>? = null
        override var queryString: String? = null
        override var queryStrings: List<String>? = null
        override var secretArn: String? = null
        override var statementName: String? = null
        override var status: StatusString? = null
        override var updatedAt: Instant? = null

        constructor(x: StatementData) : this() {
            this.createdAt = x.createdAt
            this.id = x.id
            this.isBatchStatement = x.isBatchStatement
            this.queryParameters = x.queryParameters
            this.queryString = x.queryString
            this.queryStrings = x.queryStrings
            this.secretArn = x.secretArn
            this.statementName = x.statementName
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        override fun build(): StatementData = StatementData(this)
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun isBatchStatement(isBatchStatement: Boolean): FluentBuilder = apply { this.isBatchStatement = isBatchStatement }
        override fun queryParameters(queryParameters: List<SqlParameter>): FluentBuilder = apply { this.queryParameters = queryParameters }
        override fun queryString(queryString: String): FluentBuilder = apply { this.queryString = queryString }
        override fun queryStrings(queryStrings: List<String>): FluentBuilder = apply { this.queryStrings = queryStrings }
        override fun secretArn(secretArn: String): FluentBuilder = apply { this.secretArn = secretArn }
        override fun statementName(statementName: String): FluentBuilder = apply { this.statementName = statementName }
        override fun status(status: StatusString): FluentBuilder = apply { this.status = status }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
