// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an SQL statement.
 */
class SubStatementData private constructor(builder: BuilderImpl) {
    /**
     * The date and time (UTC) the statement was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The amount of time in nanoseconds that the statement ran.
     */
    val duration: Long = builder.duration
    /**
     * The error message from the cluster if the SQL statement encountered an error while running.
     */
    val error: String? = builder.error
    /**
     * A value that indicates whether the statement has a result set. The result set can be empty.
     */
    val hasResultSet: Boolean? = builder.hasResultSet
    /**
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
     * A suffix indicates the number of the SQL statement.
     * For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the second SQL statement of a batch query.
     */
    val id: String? = builder.id
    /**
     * The SQL statement text.
     */
    val queryString: String? = builder.queryString
    /**
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
     */
    val redshiftQueryId: Long = builder.redshiftQueryId
    /**
     * Either the number of rows returned from the SQL statement or the number of rows affected.
     * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
     * A -1 indicates the value is null.
     */
    val resultRows: Long = builder.resultRows
    /**
     * The size in bytes of the returned results. A -1 indicates the value is null.
     */
    val resultSize: Long = builder.resultSize
    /**
     * The status of the SQL statement. An
     * example is the that the SQL statement finished.
     */
    val status: StatementStatusString? = builder.status
    /**
     * The date and time (UTC) that the statement metadata was last updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SubStatementData = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SubStatementData(")
        append("createdAt=$createdAt,")
        append("duration=$duration,")
        append("error=$error,")
        append("hasResultSet=$hasResultSet,")
        append("id=$id,")
        append("queryString=$queryString,")
        append("redshiftQueryId=$redshiftQueryId,")
        append("resultRows=$resultRows,")
        append("resultSize=$resultSize,")
        append("status=$status,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (duration.hashCode())
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (hasResultSet?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (redshiftQueryId.hashCode())
        result = 31 * result + (resultRows.hashCode())
        result = 31 * result + (resultSize.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SubStatementData

        if (createdAt != other.createdAt) return false
        if (duration != other.duration) return false
        if (error != other.error) return false
        if (hasResultSet != other.hasResultSet) return false
        if (id != other.id) return false
        if (queryString != other.queryString) return false
        if (redshiftQueryId != other.redshiftQueryId) return false
        if (resultRows != other.resultRows) return false
        if (resultSize != other.resultSize) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SubStatementData = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SubStatementData
        /**
         * The date and time (UTC) the statement was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The amount of time in nanoseconds that the statement ran.
         */
        fun duration(duration: Long): FluentBuilder
        /**
         * The error message from the cluster if the SQL statement encountered an error while running.
         */
        fun error(error: String): FluentBuilder
        /**
         * A value that indicates whether the statement has a result set. The result set can be empty.
         */
        fun hasResultSet(hasResultSet: Boolean): FluentBuilder
        /**
         * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         * A suffix indicates the number of the SQL statement.
         * For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the second SQL statement of a batch query.
         */
        fun id(id: String): FluentBuilder
        /**
         * The SQL statement text.
         */
        fun queryString(queryString: String): FluentBuilder
        /**
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        fun redshiftQueryId(redshiftQueryId: Long): FluentBuilder
        /**
         * Either the number of rows returned from the SQL statement or the number of rows affected.
         * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
         * A -1 indicates the value is null.
         */
        fun resultRows(resultRows: Long): FluentBuilder
        /**
         * The size in bytes of the returned results. A -1 indicates the value is null.
         */
        fun resultSize(resultSize: Long): FluentBuilder
        /**
         * The status of the SQL statement. An
         * example is the that the SQL statement finished.
         */
        fun status(status: StatementStatusString): FluentBuilder
        /**
         * The date and time (UTC) that the statement metadata was last updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time (UTC) the statement was created.
         */
        var createdAt: Instant?
        /**
         * The amount of time in nanoseconds that the statement ran.
         */
        var duration: Long
        /**
         * The error message from the cluster if the SQL statement encountered an error while running.
         */
        var error: String?
        /**
         * A value that indicates whether the statement has a result set. The result set can be empty.
         */
        var hasResultSet: Boolean?
        /**
         * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         * A suffix indicates the number of the SQL statement.
         * For example, d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the second SQL statement of a batch query.
         */
        var id: String?
        /**
         * The SQL statement text.
         */
        var queryString: String?
        /**
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
         */
        var redshiftQueryId: Long
        /**
         * Either the number of rows returned from the SQL statement or the number of rows affected.
         * If result size is greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE, DELETE, COPY, and others.
         * A -1 indicates the value is null.
         */
        var resultRows: Long
        /**
         * The size in bytes of the returned results. A -1 indicates the value is null.
         */
        var resultSize: Long
        /**
         * The status of the SQL statement. An
         * example is the that the SQL statement finished.
         */
        var status: StatementStatusString?
        /**
         * The date and time (UTC) that the statement metadata was last updated.
         */
        var updatedAt: Instant?

        fun build(): SubStatementData
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var createdAt: Instant? = null
        override var duration: Long = 0L
        override var error: String? = null
        override var hasResultSet: Boolean? = null
        override var id: String? = null
        override var queryString: String? = null
        override var redshiftQueryId: Long = 0L
        override var resultRows: Long = 0L
        override var resultSize: Long = 0L
        override var status: StatementStatusString? = null
        override var updatedAt: Instant? = null

        constructor(x: SubStatementData) : this() {
            this.createdAt = x.createdAt
            this.duration = x.duration
            this.error = x.error
            this.hasResultSet = x.hasResultSet
            this.id = x.id
            this.queryString = x.queryString
            this.redshiftQueryId = x.redshiftQueryId
            this.resultRows = x.resultRows
            this.resultSize = x.resultSize
            this.status = x.status
            this.updatedAt = x.updatedAt
        }

        override fun build(): SubStatementData = SubStatementData(this)
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun duration(duration: Long): FluentBuilder = apply { this.duration = duration }
        override fun error(error: String): FluentBuilder = apply { this.error = error }
        override fun hasResultSet(hasResultSet: Boolean): FluentBuilder = apply { this.hasResultSet = hasResultSet }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun queryString(queryString: String): FluentBuilder = apply { this.queryString = queryString }
        override fun redshiftQueryId(redshiftQueryId: Long): FluentBuilder = apply { this.redshiftQueryId = redshiftQueryId }
        override fun resultRows(resultRows: Long): FluentBuilder = apply { this.resultRows = resultRows }
        override fun resultSize(resultSize: Long): FluentBuilder = apply { this.resultSize = resultSize }
        override fun status(status: StatementStatusString): FluentBuilder = apply { this.status = status }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
