// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftdata.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftdata.model.ExecuteStatementResponse
import aws.sdk.kotlin.services.redshiftdata.model.RedshiftDataException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class ExecuteStatementOperationDeserializer: HttpDeserialize<ExecuteStatementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ExecuteStatementResponse {
        if (!response.status.isSuccess()) {
            throwExecuteStatementError(context, response)
        }
        val builder = ExecuteStatementResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeExecuteStatementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeExecuteStatementOperationBody(builder: ExecuteStatementResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterIdentifier"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DATABASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Database"))
    val DBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DbUser"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val SECRETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DATABASE_DESCRIPTOR)
        field(DBUSER_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(SECRETARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATABASE_DESCRIPTOR.index -> builder.database = deserializeString()
                DBUSER_DESCRIPTOR.index -> builder.dbUser = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                SECRETARN_DESCRIPTOR.index -> builder.secretArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwExecuteStatementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ActiveStatementsExceededException" -> ActiveStatementsExceededExceptionDeserializer()
        "ExecuteStatementException" -> ExecuteStatementExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw RedshiftDataException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
