// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.redshiftserverless.model.*
import aws.sdk.kotlin.services.redshiftserverless.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Redshift Serverless"
public const val ServiceApiVersion: String = "2021-04-21"
public const val SdkVersion: String = "0.17.3-beta"

internal class DefaultRedshiftServerlessClient(override val config: RedshiftServerlessClient.Config) : RedshiftServerlessClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    override suspend fun convertRecoveryPointToSnapshot(input: ConvertRecoveryPointToSnapshotRequest): ConvertRecoveryPointToSnapshotResponse {
        val op = SdkHttpOperation.build<ConvertRecoveryPointToSnapshotRequest, ConvertRecoveryPointToSnapshotResponse> {
            serializer = ConvertRecoveryPointToSnapshotOperationSerializer()
            deserializer = ConvertRecoveryPointToSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConvertRecoveryPointToSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     */
    override suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse {
        val op = SdkHttpOperation.build<CreateEndpointAccessRequest, CreateEndpointAccessResponse> {
            serializer = CreateEndpointAccessOperationSerializer()
            deserializer = CreateEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a namespace in Amazon Redshift Serverless.
     */
    override suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse {
        val op = SdkHttpOperation.build<CreateNamespaceRequest, CreateNamespaceResponse> {
            serializer = CreateNamespaceOperationSerializer()
            deserializer = CreateNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    override suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse {
        val op = SdkHttpOperation.build<CreateSnapshotRequest, CreateSnapshotResponse> {
            serializer = CreateSnapshotOperationSerializer()
            deserializer = CreateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
     */
    override suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse {
        val op = SdkHttpOperation.build<CreateUsageLimitRequest, CreateUsageLimitResponse> {
            serializer = CreateUsageLimitOperationSerializer()
            deserializer = CreateUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an workgroup in Amazon Redshift Serverless.
     */
    override suspend fun createWorkgroup(input: CreateWorkgroupRequest): CreateWorkgroupResponse {
        val op = SdkHttpOperation.build<CreateWorkgroupRequest, CreateWorkgroupResponse> {
            serializer = CreateWorkgroupOperationSerializer()
            deserializer = CreateWorkgroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkgroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     */
    override suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse {
        val op = SdkHttpOperation.build<DeleteEndpointAccessRequest, DeleteEndpointAccessResponse> {
            serializer = DeleteEndpointAccessOperationSerializer()
            deserializer = DeleteEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
     */
    override suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse {
        val op = SdkHttpOperation.build<DeleteNamespaceRequest, DeleteNamespaceResponse> {
            serializer = DeleteNamespaceOperationSerializer()
            deserializer = DeleteNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified resource policy.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a snapshot from Amazon Redshift Serverless.
     */
    override suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteSnapshotRequest, DeleteSnapshotResponse> {
            serializer = DeleteSnapshotOperationSerializer()
            deserializer = DeleteSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a usage limit from Amazon Redshift Serverless.
     */
    override suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse {
        val op = SdkHttpOperation.build<DeleteUsageLimitRequest, DeleteUsageLimitResponse> {
            serializer = DeleteUsageLimitOperationSerializer()
            deserializer = DeleteUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a workgroup.
     */
    override suspend fun deleteWorkgroup(input: DeleteWorkgroupRequest): DeleteWorkgroupResponse {
        val op = SdkHttpOperation.build<DeleteWorkgroupRequest, DeleteWorkgroupResponse> {
            serializer = DeleteWorkgroupOperationSerializer()
            deserializer = DeleteWorkgroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkgroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
     *
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
     *
     *  The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
     *
     *  If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
     */
    override suspend fun getCredentials(input: GetCredentialsRequest): GetCredentialsResponse {
        val op = SdkHttpOperation.build<GetCredentialsRequest, GetCredentialsResponse> {
            serializer = GetCredentialsOperationSerializer()
            deserializer = GetCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information, such as the name, about a VPC endpoint.
     */
    override suspend fun getEndpointAccess(input: GetEndpointAccessRequest): GetEndpointAccessResponse {
        val op = SdkHttpOperation.build<GetEndpointAccessRequest, GetEndpointAccessResponse> {
            serializer = GetEndpointAccessOperationSerializer()
            deserializer = GetEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a namespace in Amazon Redshift Serverless.
     */
    override suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse {
        val op = SdkHttpOperation.build<GetNamespaceRequest, GetNamespaceResponse> {
            serializer = GetNamespaceOperationSerializer()
            deserializer = GetNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a recovery point.
     */
    override suspend fun getRecoveryPoint(input: GetRecoveryPointRequest): GetRecoveryPointResponse {
        val op = SdkHttpOperation.build<GetRecoveryPointRequest, GetRecoveryPointResponse> {
            serializer = GetRecoveryPointOperationSerializer()
            deserializer = GetRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecoveryPoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a resource policy.
     */
    override suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse {
        val op = SdkHttpOperation.build<GetResourcePolicyRequest, GetResourcePolicyResponse> {
            serializer = GetResourcePolicyOperationSerializer()
            deserializer = GetResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific snapshot.
     */
    override suspend fun getSnapshot(input: GetSnapshotRequest): GetSnapshotResponse {
        val op = SdkHttpOperation.build<GetSnapshotRequest, GetSnapshotResponse> {
            serializer = GetSnapshotOperationSerializer()
            deserializer = GetSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a usage limit.
     */
    override suspend fun getUsageLimit(input: GetUsageLimitRequest): GetUsageLimitResponse {
        val op = SdkHttpOperation.build<GetUsageLimitRequest, GetUsageLimitResponse> {
            serializer = GetUsageLimitOperationSerializer()
            deserializer = GetUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific workgroup.
     */
    override suspend fun getWorkgroup(input: GetWorkgroupRequest): GetWorkgroupResponse {
        val op = SdkHttpOperation.build<GetWorkgroupRequest, GetWorkgroupResponse> {
            serializer = GetWorkgroupOperationSerializer()
            deserializer = GetWorkgroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkgroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `EndpointAccess` objects and relevant information.
     */
    override suspend fun listEndpointAccess(input: ListEndpointAccessRequest): ListEndpointAccessResponse {
        val op = SdkHttpOperation.build<ListEndpointAccessRequest, ListEndpointAccessResponse> {
            serializer = ListEndpointAccessOperationSerializer()
            deserializer = ListEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a list of specified namespaces.
     */
    override suspend fun listNamespaces(input: ListNamespacesRequest): ListNamespacesResponse {
        val op = SdkHttpOperation.build<ListNamespacesRequest, ListNamespacesResponse> {
            serializer = ListNamespacesOperationSerializer()
            deserializer = ListNamespacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNamespaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of recovery points.
     */
    override suspend fun listRecoveryPoints(input: ListRecoveryPointsRequest): ListRecoveryPointsResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsRequest, ListRecoveryPointsResponse> {
            serializer = ListRecoveryPointsOperationSerializer()
            deserializer = ListRecoveryPointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecoveryPoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of snapshots.
     */
    override suspend fun listSnapshots(input: ListSnapshotsRequest): ListSnapshotsResponse {
        val op = SdkHttpOperation.build<ListSnapshotsRequest, ListSnapshotsResponse> {
            serializer = ListSnapshotsOperationSerializer()
            deserializer = ListSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSnapshots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags assigned to a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all usage limits within Amazon Redshift Serverless.
     */
    override suspend fun listUsageLimits(input: ListUsageLimitsRequest): ListUsageLimitsResponse {
        val op = SdkHttpOperation.build<ListUsageLimitsRequest, ListUsageLimitsResponse> {
            serializer = ListUsageLimitsOperationSerializer()
            deserializer = ListUsageLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsageLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a list of specified workgroups.
     */
    override suspend fun listWorkgroups(input: ListWorkgroupsRequest): ListWorkgroupsResponse {
        val op = SdkHttpOperation.build<ListWorkgroupsRequest, ListWorkgroupsResponse> {
            serializer = ListWorkgroupsOperationSerializer()
            deserializer = ListWorkgroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkgroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializer = PutResourcePolicyOperationSerializer()
            deserializer = PutResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restore the data from a recovery point.
     */
    override suspend fun restoreFromRecoveryPoint(input: RestoreFromRecoveryPointRequest): RestoreFromRecoveryPointResponse {
        val op = SdkHttpOperation.build<RestoreFromRecoveryPointRequest, RestoreFromRecoveryPointResponse> {
            serializer = RestoreFromRecoveryPointOperationSerializer()
            deserializer = RestoreFromRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreFromRecoveryPoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores a namespace from a snapshot.
     */
    override suspend fun restoreFromSnapshot(input: RestoreFromSnapshotRequest): RestoreFromSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreFromSnapshotRequest, RestoreFromSnapshotResponse> {
            serializer = RestoreFromSnapshotOperationSerializer()
            deserializer = RestoreFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreFromSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag or set of tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon Redshift Serverless managed endpoint.
     */
    override suspend fun updateEndpointAccess(input: UpdateEndpointAccessRequest): UpdateEndpointAccessResponse {
        val op = SdkHttpOperation.build<UpdateEndpointAccessRequest, UpdateEndpointAccessResponse> {
            serializer = UpdateEndpointAccessOperationSerializer()
            deserializer = UpdateEndpointAccessOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpointAccess"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a namespace with the specified settings.
     */
    override suspend fun updateNamespace(input: UpdateNamespaceRequest): UpdateNamespaceResponse {
        val op = SdkHttpOperation.build<UpdateNamespaceRequest, UpdateNamespaceResponse> {
            serializer = UpdateNamespaceOperationSerializer()
            deserializer = UpdateNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a snapshot.
     */
    override suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse {
        val op = SdkHttpOperation.build<UpdateSnapshotRequest, UpdateSnapshotResponse> {
            serializer = UpdateSnapshotOperationSerializer()
            deserializer = UpdateSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSnapshot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     */
    override suspend fun updateUsageLimit(input: UpdateUsageLimitRequest): UpdateUsageLimitResponse {
        val op = SdkHttpOperation.build<UpdateUsageLimitRequest, UpdateUsageLimitResponse> {
            serializer = UpdateUsageLimitOperationSerializer()
            deserializer = UpdateUsageLimitOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUsageLimit"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a workgroup with the specified configuration settings.
     */
    override suspend fun updateWorkgroup(input: UpdateWorkgroupRequest): UpdateWorkgroupResponse {
        val op = SdkHttpOperation.build<UpdateWorkgroupRequest, UpdateWorkgroupResponse> {
            serializer = UpdateWorkgroupOperationSerializer()
            deserializer = UpdateWorkgroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkgroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("RedshiftServerless", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "redshift-serverless"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "redshift-serverless")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
