// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.redshiftserverless.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.redshiftserverless.model.*
import aws.sdk.kotlin.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ConvertRecoveryPointToSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.CreateWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.DeleteWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.GetWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.GetWorkgroupResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListNamespacesRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListNamespacesResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListRecoveryPointsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListRecoveryPointsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListSnapshotsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListUsageLimitsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListUsageLimitsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.ListWorkgroupsRequest
import aws.sdk.kotlin.services.redshiftserverless.model.ListWorkgroupsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.redshiftserverless.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromRecoveryPointResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.RestoreFromSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.TagResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.TagResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UntagResourceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UntagResourceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateEndpointAccessRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateEndpointAccessResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateNamespaceResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateSnapshotResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateUsageLimitRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateUsageLimitResponse
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateWorkgroupRequest
import aws.sdk.kotlin.services.redshiftserverless.model.UpdateWorkgroupResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift Serverless.
 *
 * Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift Serverless lets you focus on using your data to acquire new insights for your business and customers.
 *
 *  To learn more about Amazon Redshift Serverless, see [What is Amazon Redshift Serverless](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html).
 */
public interface RedshiftServerlessClient : SdkClient {

    override val serviceName: String
        get() = "Redshift Serverless"
    /**
     * RedshiftServerlessClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): RedshiftServerlessClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRedshiftServerlessClient(config)
        }

        public operator fun invoke(config: Config): RedshiftServerlessClient = DefaultRedshiftServerlessClient(config)

        /**
         * Construct a [RedshiftServerlessClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RedshiftServerlessClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRedshiftServerlessClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    public suspend fun convertRecoveryPointToSnapshot(input: ConvertRecoveryPointToSnapshotRequest): ConvertRecoveryPointToSnapshotResponse

    /**
     * Creates an Amazon Redshift Serverless managed VPC endpoint.
     */
    public suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse

    /**
     * Creates a namespace in Amazon Redshift Serverless.
     */
    public suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse

    /**
     * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
     */
    public suspend fun createSnapshot(input: CreateSnapshotRequest): CreateSnapshotResponse

    /**
     * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
     */
    public suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse

    /**
     * Creates an workgroup in Amazon Redshift Serverless.
     */
    public suspend fun createWorkgroup(input: CreateWorkgroupRequest): CreateWorkgroupResponse

    /**
     * Deletes an Amazon Redshift Serverless managed VPC endpoint.
     */
    public suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse

    /**
     * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes the specified resource policy.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a snapshot from Amazon Redshift Serverless.
     */
    public suspend fun deleteSnapshot(input: DeleteSnapshotRequest): DeleteSnapshotResponse

    /**
     * Deletes a usage limit from Amazon Redshift Serverless.
     */
    public suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse

    /**
     * Deletes a workgroup.
     */
    public suspend fun deleteWorkgroup(input: DeleteWorkgroupRequest): DeleteWorkgroupResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
     *
     * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
     *
     *  The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
     *
     *  If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
     */
    public suspend fun getCredentials(input: GetCredentialsRequest): GetCredentialsResponse

    /**
     * Returns information, such as the name, about a VPC endpoint.
     */
    public suspend fun getEndpointAccess(input: GetEndpointAccessRequest): GetEndpointAccessResponse

    /**
     * Returns information about a namespace in Amazon Redshift Serverless.
     */
    public suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse

    /**
     * Returns information about a recovery point.
     */
    public suspend fun getRecoveryPoint(input: GetRecoveryPointRequest): GetRecoveryPointResponse

    /**
     * Returns a resource policy.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Returns information about a specific snapshot.
     */
    public suspend fun getSnapshot(input: GetSnapshotRequest = GetSnapshotRequest {}): GetSnapshotResponse

    /**
     * Returns information about a usage limit.
     */
    public suspend fun getUsageLimit(input: GetUsageLimitRequest): GetUsageLimitResponse

    /**
     * Returns information about a specific workgroup.
     */
    public suspend fun getWorkgroup(input: GetWorkgroupRequest): GetWorkgroupResponse

    /**
     * Returns an array of `EndpointAccess` objects and relevant information.
     */
    public suspend fun listEndpointAccess(input: ListEndpointAccessRequest = ListEndpointAccessRequest {}): ListEndpointAccessResponse

    /**
     * Returns information about a list of specified namespaces.
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest = ListNamespacesRequest {}): ListNamespacesResponse

    /**
     * Returns an array of recovery points.
     */
    public suspend fun listRecoveryPoints(input: ListRecoveryPointsRequest = ListRecoveryPointsRequest {}): ListRecoveryPointsResponse

    /**
     * Returns a list of snapshots.
     */
    public suspend fun listSnapshots(input: ListSnapshotsRequest = ListSnapshotsRequest {}): ListSnapshotsResponse

    /**
     * Lists the tags assigned to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all usage limits within Amazon Redshift Serverless.
     */
    public suspend fun listUsageLimits(input: ListUsageLimitsRequest = ListUsageLimitsRequest {}): ListUsageLimitsResponse

    /**
     * Returns information about a list of specified workgroups.
     */
    public suspend fun listWorkgroups(input: ListWorkgroupsRequest = ListWorkgroupsRequest {}): ListWorkgroupsResponse

    /**
     * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Restore the data from a recovery point.
     */
    public suspend fun restoreFromRecoveryPoint(input: RestoreFromRecoveryPointRequest): RestoreFromRecoveryPointResponse

    /**
     * Restores a namespace from a snapshot.
     */
    public suspend fun restoreFromSnapshot(input: RestoreFromSnapshotRequest): RestoreFromSnapshotResponse

    /**
     * Assigns one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or set of tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Redshift Serverless managed endpoint.
     */
    public suspend fun updateEndpointAccess(input: UpdateEndpointAccessRequest): UpdateEndpointAccessResponse

    /**
     * Updates a namespace with the specified settings.
     */
    public suspend fun updateNamespace(input: UpdateNamespaceRequest): UpdateNamespaceResponse

    /**
     * Updates a snapshot.
     */
    public suspend fun updateSnapshot(input: UpdateSnapshotRequest): UpdateSnapshotResponse

    /**
     * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
     */
    public suspend fun updateUsageLimit(input: UpdateUsageLimitRequest): UpdateUsageLimitResponse

    /**
     * Updates a workgroup with the specified configuration settings.
     */
    public suspend fun updateWorkgroup(input: UpdateWorkgroupRequest): UpdateWorkgroupResponse
}

/**
 * Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see [Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
public suspend inline fun RedshiftServerlessClient.convertRecoveryPointToSnapshot(crossinline block: ConvertRecoveryPointToSnapshotRequest.Builder.() -> Unit): ConvertRecoveryPointToSnapshotResponse = convertRecoveryPointToSnapshot(ConvertRecoveryPointToSnapshotRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift Serverless managed VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.createEndpointAccess(crossinline block: CreateEndpointAccessRequest.Builder.() -> Unit): CreateEndpointAccessResponse = createEndpointAccess(CreateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Creates a namespace in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.createNamespace(crossinline block: CreateNamespaceRequest.Builder.() -> Unit): CreateNamespaceResponse = createNamespace(CreateNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a snapshot of all databases in a namespace. For more information about snapshots, see [ Working with snapshots and recovery points](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
 */
public suspend inline fun RedshiftServerlessClient.createSnapshot(crossinline block: CreateSnapshotRequest.Builder.() -> Unit): CreateSnapshotResponse = createSnapshot(CreateSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier.
 */
public suspend inline fun RedshiftServerlessClient.createUsageLimit(crossinline block: CreateUsageLimitRequest.Builder.() -> Unit): CreateUsageLimitResponse = createUsageLimit(CreateUsageLimitRequest.Builder().apply(block).build())

/**
 * Creates an workgroup in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.createWorkgroup(crossinline block: CreateWorkgroupRequest.Builder.() -> Unit): CreateWorkgroupResponse = createWorkgroup(CreateWorkgroupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift Serverless managed VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.deleteEndpointAccess(crossinline block: DeleteEndpointAccessRequest.Builder.() -> Unit): DeleteEndpointAccessResponse = deleteEndpointAccess(DeleteEndpointAccessRequest.Builder().apply(block).build())

/**
 * Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.
 */
public suspend inline fun RedshiftServerlessClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource policy.
 */
public suspend inline fun RedshiftServerlessClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot from Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.deleteSnapshot(crossinline block: DeleteSnapshotRequest.Builder.() -> Unit): DeleteSnapshotResponse = deleteSnapshot(DeleteSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes a usage limit from Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.deleteUsageLimit(crossinline block: DeleteUsageLimitRequest.Builder.() -> Unit): DeleteUsageLimitResponse = deleteUsageLimit(DeleteUsageLimitRequest.Builder().apply(block).build())

/**
 * Deletes a workgroup.
 */
public suspend inline fun RedshiftServerlessClient.deleteWorkgroup(crossinline block: DeleteWorkgroupRequest.Builder.() -> Unit): DeleteWorkgroupResponse = deleteWorkgroup(DeleteWorkgroupRequest.Builder().apply(block).build())

/**
 * Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.
 *
 * By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).
 *
 *  The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.
 *
 *  If the `DbName` parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.
 */
public suspend inline fun RedshiftServerlessClient.getCredentials(crossinline block: GetCredentialsRequest.Builder.() -> Unit): GetCredentialsResponse = getCredentials(GetCredentialsRequest.Builder().apply(block).build())

/**
 * Returns information, such as the name, about a VPC endpoint.
 */
public suspend inline fun RedshiftServerlessClient.getEndpointAccess(crossinline block: GetEndpointAccessRequest.Builder.() -> Unit): GetEndpointAccessResponse = getEndpointAccess(GetEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a namespace in Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.getNamespace(crossinline block: GetNamespaceRequest.Builder.() -> Unit): GetNamespaceResponse = getNamespace(GetNamespaceRequest.Builder().apply(block).build())

/**
 * Returns information about a recovery point.
 */
public suspend inline fun RedshiftServerlessClient.getRecoveryPoint(crossinline block: GetRecoveryPointRequest.Builder.() -> Unit): GetRecoveryPointResponse = getRecoveryPoint(GetRecoveryPointRequest.Builder().apply(block).build())

/**
 * Returns a resource policy.
 */
public suspend inline fun RedshiftServerlessClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Returns information about a specific snapshot.
 */
public suspend inline fun RedshiftServerlessClient.getSnapshot(crossinline block: GetSnapshotRequest.Builder.() -> Unit): GetSnapshotResponse = getSnapshot(GetSnapshotRequest.Builder().apply(block).build())

/**
 * Returns information about a usage limit.
 */
public suspend inline fun RedshiftServerlessClient.getUsageLimit(crossinline block: GetUsageLimitRequest.Builder.() -> Unit): GetUsageLimitResponse = getUsageLimit(GetUsageLimitRequest.Builder().apply(block).build())

/**
 * Returns information about a specific workgroup.
 */
public suspend inline fun RedshiftServerlessClient.getWorkgroup(crossinline block: GetWorkgroupRequest.Builder.() -> Unit): GetWorkgroupResponse = getWorkgroup(GetWorkgroupRequest.Builder().apply(block).build())

/**
 * Returns an array of `EndpointAccess` objects and relevant information.
 */
public suspend inline fun RedshiftServerlessClient.listEndpointAccess(crossinline block: ListEndpointAccessRequest.Builder.() -> Unit): ListEndpointAccessResponse = listEndpointAccess(ListEndpointAccessRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified namespaces.
 */
public suspend inline fun RedshiftServerlessClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Returns an array of recovery points.
 */
public suspend inline fun RedshiftServerlessClient.listRecoveryPoints(crossinline block: ListRecoveryPointsRequest.Builder.() -> Unit): ListRecoveryPointsResponse = listRecoveryPoints(ListRecoveryPointsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshots.
 */
public suspend inline fun RedshiftServerlessClient.listSnapshots(crossinline block: ListSnapshotsRequest.Builder.() -> Unit): ListSnapshotsResponse = listSnapshots(ListSnapshotsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 */
public suspend inline fun RedshiftServerlessClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all usage limits within Amazon Redshift Serverless.
 */
public suspend inline fun RedshiftServerlessClient.listUsageLimits(crossinline block: ListUsageLimitsRequest.Builder.() -> Unit): ListUsageLimitsResponse = listUsageLimits(ListUsageLimitsRequest.Builder().apply(block).build())

/**
 * Returns information about a list of specified workgroups.
 */
public suspend inline fun RedshiftServerlessClient.listWorkgroups(crossinline block: ListWorkgroupsRequest.Builder.() -> Unit): ListWorkgroupsResponse = listWorkgroups(ListWorkgroupsRequest.Builder().apply(block).build())

/**
 * Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.
 */
public suspend inline fun RedshiftServerlessClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Restore the data from a recovery point.
 */
public suspend inline fun RedshiftServerlessClient.restoreFromRecoveryPoint(crossinline block: RestoreFromRecoveryPointRequest.Builder.() -> Unit): RestoreFromRecoveryPointResponse = restoreFromRecoveryPoint(RestoreFromRecoveryPointRequest.Builder().apply(block).build())

/**
 * Restores a namespace from a snapshot.
 */
public suspend inline fun RedshiftServerlessClient.restoreFromSnapshot(crossinline block: RestoreFromSnapshotRequest.Builder.() -> Unit): RestoreFromSnapshotResponse = restoreFromSnapshot(RestoreFromSnapshotRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags to a resource.
 */
public suspend inline fun RedshiftServerlessClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or set of tags from a resource.
 */
public suspend inline fun RedshiftServerlessClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Redshift Serverless managed endpoint.
 */
public suspend inline fun RedshiftServerlessClient.updateEndpointAccess(crossinline block: UpdateEndpointAccessRequest.Builder.() -> Unit): UpdateEndpointAccessResponse = updateEndpointAccess(UpdateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Updates a namespace with the specified settings.
 */
public suspend inline fun RedshiftServerlessClient.updateNamespace(crossinline block: UpdateNamespaceRequest.Builder.() -> Unit): UpdateNamespaceResponse = updateNamespace(UpdateNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a snapshot.
 */
public suspend inline fun RedshiftServerlessClient.updateSnapshot(crossinline block: UpdateSnapshotRequest.Builder.() -> Unit): UpdateSnapshotResponse = updateSnapshot(UpdateSnapshotRequest.Builder().apply(block).build())

/**
 * Update a usage limit in Amazon Redshift Serverless. You can't update the usage type or period of a usage limit.
 */
public suspend inline fun RedshiftServerlessClient.updateUsageLimit(crossinline block: UpdateUsageLimitRequest.Builder.() -> Unit): UpdateUsageLimitResponse = updateUsageLimit(UpdateUsageLimitRequest.Builder().apply(block).build())

/**
 * Updates a workgroup with the specified configuration settings.
 */
public suspend inline fun RedshiftServerlessClient.updateWorkgroup(crossinline block: UpdateWorkgroupRequest.Builder.() -> Unit): UpdateWorkgroupResponse = updateWorkgroup(UpdateWorkgroupRequest.Builder().apply(block).build())
