// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The automatically created recovery point of a namespace. Recovery points are created every 30 minutes and kept for 24 hours.
 */
public class RecoveryPoint private constructor(builder: Builder) {
    /**
     * The name of the namespace the recovery point is associated with.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The time the recovery point is created.
     */
    public val recoveryPointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.recoveryPointCreateTime
    /**
     * The unique identifier of the recovery point.
     */
    public val recoveryPointId: kotlin.String? = builder.recoveryPointId
    /**
     * The total size of the data in the recovery point in megabytes.
     */
    public val totalSizeInMegaBytes: kotlin.Double? = builder.totalSizeInMegaBytes
    /**
     * The name of the workgroup the recovery point is associated with.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPoint(")
        append("namespaceName=$namespaceName,")
        append("recoveryPointCreateTime=$recoveryPointCreateTime,")
        append("recoveryPointId=$recoveryPointId,")
        append("totalSizeInMegaBytes=$totalSizeInMegaBytes,")
        append("workgroupName=$workgroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespaceName?.hashCode() ?: 0
        result = 31 * result + (recoveryPointCreateTime?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointId?.hashCode() ?: 0)
        result = 31 * result + (totalSizeInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPoint

        if (namespaceName != other.namespaceName) return false
        if (recoveryPointCreateTime != other.recoveryPointCreateTime) return false
        if (recoveryPointId != other.recoveryPointId) return false
        if (totalSizeInMegaBytes != other.totalSizeInMegaBytes) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the namespace the recovery point is associated with.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The time the recovery point is created.
         */
        public var recoveryPointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the recovery point.
         */
        public var recoveryPointId: kotlin.String? = null
        /**
         * The total size of the data in the recovery point in megabytes.
         */
        public var totalSizeInMegaBytes: kotlin.Double? = null
        /**
         * The name of the workgroup the recovery point is associated with.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint) : this() {
            this.namespaceName = x.namespaceName
            this.recoveryPointCreateTime = x.recoveryPointCreateTime
            this.recoveryPointId = x.recoveryPointId
            this.totalSizeInMegaBytes = x.totalSizeInMegaBytes
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.RecoveryPoint = RecoveryPoint(this)
    }
}
