// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A snapshot object that contains databases.
 */
public class Snapshot private constructor(builder: Builder) {
    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     */
    public val accountsWithProvisionedRestoreAccess: List<String>? = builder.accountsWithProvisionedRestoreAccess
    /**
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     */
    public val accountsWithRestoreAccess: List<String>? = builder.accountsWithRestoreAccess
    /**
     * The size of the incremental backup in megabytes.
     */
    public val actualIncrementalBackupSizeInMegaBytes: kotlin.Double? = builder.actualIncrementalBackupSizeInMegaBytes
    /**
     * The username of the database within a snapshot.
     */
    public val adminUsername: kotlin.String? = builder.adminUsername
    /**
     * The size in megabytes of the data that has been backed up to a snapshot.
     */
    public val backupProgressInMegaBytes: kotlin.Double? = builder.backupProgressInMegaBytes
    /**
     * The rate at which data is backed up into a snapshot in megabytes per second.
     */
    public val currentBackupRateInMegaBytesPerSecond: kotlin.Double? = builder.currentBackupRateInMegaBytesPerSecond
    /**
     * The amount of time it took to back up data into a snapshot.
     */
    public val elapsedTimeInSeconds: kotlin.Long? = builder.elapsedTimeInSeconds
    /**
     * The estimated amount of seconds until the snapshot completes backup.
     */
    public val estimatedSecondsToCompletion: kotlin.Long? = builder.estimatedSecondsToCompletion
    /**
     * The unique identifier of the KMS key used to encrypt the snapshot.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     */
    public val namespaceArn: kotlin.String? = builder.namespaceArn
    /**
     * The name of the namepsace.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * The owner Amazon Web Services; account of the snapshot.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The Amazon Resource Name (ARN) of the snapshot.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn
    /**
     * The timestamp of when the snapshot was created.
     */
    public val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * The name of the snapshot.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The amount of days until the snapshot is deleted.
     */
    public val snapshotRemainingDays: kotlin.Int? = builder.snapshotRemainingDays
    /**
     * The period of time, in days, of how long the snapshot is retained.
     */
    public val snapshotRetentionPeriod: kotlin.Int? = builder.snapshotRetentionPeriod
    /**
     * The timestamp of when data within the snapshot started getting retained.
     */
    public val snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotRetentionStartTime
    /**
     * The status of the snapshot.
     */
    public val status: aws.sdk.kotlin.services.redshiftserverless.model.SnapshotStatus? = builder.status
    /**
     * The total size, in megabytes, of how big the snapshot is.
     */
    public val totalBackupSizeInMegaBytes: kotlin.Double? = builder.totalBackupSizeInMegaBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("accountsWithProvisionedRestoreAccess=$accountsWithProvisionedRestoreAccess,")
        append("accountsWithRestoreAccess=$accountsWithRestoreAccess,")
        append("actualIncrementalBackupSizeInMegaBytes=$actualIncrementalBackupSizeInMegaBytes,")
        append("adminUsername=$adminUsername,")
        append("backupProgressInMegaBytes=$backupProgressInMegaBytes,")
        append("currentBackupRateInMegaBytesPerSecond=$currentBackupRateInMegaBytesPerSecond,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("estimatedSecondsToCompletion=$estimatedSecondsToCompletion,")
        append("kmsKeyId=$kmsKeyId,")
        append("namespaceArn=$namespaceArn,")
        append("namespaceName=$namespaceName,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotArn=$snapshotArn,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotName=$snapshotName,")
        append("snapshotRemainingDays=$snapshotRemainingDays,")
        append("snapshotRetentionPeriod=$snapshotRetentionPeriod,")
        append("snapshotRetentionStartTime=$snapshotRetentionStartTime,")
        append("status=$status,")
        append("totalBackupSizeInMegaBytes=$totalBackupSizeInMegaBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountsWithProvisionedRestoreAccess?.hashCode() ?: 0
        result = 31 * result + (accountsWithRestoreAccess?.hashCode() ?: 0)
        result = 31 * result + (actualIncrementalBackupSizeInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (adminUsername?.hashCode() ?: 0)
        result = 31 * result + (backupProgressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (currentBackupRateInMegaBytesPerSecond?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (estimatedSecondsToCompletion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (namespaceArn?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRemainingDays ?: 0)
        result = 31 * result + (snapshotRetentionPeriod ?: 0)
        result = 31 * result + (snapshotRetentionStartTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (totalBackupSizeInMegaBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (accountsWithProvisionedRestoreAccess != other.accountsWithProvisionedRestoreAccess) return false
        if (accountsWithRestoreAccess != other.accountsWithRestoreAccess) return false
        if (actualIncrementalBackupSizeInMegaBytes != other.actualIncrementalBackupSizeInMegaBytes) return false
        if (adminUsername != other.adminUsername) return false
        if (backupProgressInMegaBytes != other.backupProgressInMegaBytes) return false
        if (currentBackupRateInMegaBytesPerSecond != other.currentBackupRateInMegaBytesPerSecond) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (estimatedSecondsToCompletion != other.estimatedSecondsToCompletion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (namespaceArn != other.namespaceArn) return false
        if (namespaceName != other.namespaceName) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotArn != other.snapshotArn) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotRemainingDays != other.snapshotRemainingDays) return false
        if (snapshotRetentionPeriod != other.snapshotRetentionPeriod) return false
        if (snapshotRetentionStartTime != other.snapshotRetentionStartTime) return false
        if (status != other.status) return false
        if (totalBackupSizeInMegaBytes != other.totalBackupSizeInMegaBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.Snapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
         */
        public var accountsWithProvisionedRestoreAccess: List<String>? = null
        /**
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
         */
        public var accountsWithRestoreAccess: List<String>? = null
        /**
         * The size of the incremental backup in megabytes.
         */
        public var actualIncrementalBackupSizeInMegaBytes: kotlin.Double? = null
        /**
         * The username of the database within a snapshot.
         */
        public var adminUsername: kotlin.String? = null
        /**
         * The size in megabytes of the data that has been backed up to a snapshot.
         */
        public var backupProgressInMegaBytes: kotlin.Double? = null
        /**
         * The rate at which data is backed up into a snapshot in megabytes per second.
         */
        public var currentBackupRateInMegaBytesPerSecond: kotlin.Double? = null
        /**
         * The amount of time it took to back up data into a snapshot.
         */
        public var elapsedTimeInSeconds: kotlin.Long? = null
        /**
         * The estimated amount of seconds until the snapshot completes backup.
         */
        public var estimatedSecondsToCompletion: kotlin.Long? = null
        /**
         * The unique identifier of the KMS key used to encrypt the snapshot.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
         */
        public var namespaceArn: kotlin.String? = null
        /**
         * The name of the namepsace.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * The owner Amazon Web Services; account of the snapshot.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The timestamp of when the snapshot was created.
         */
        public var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the snapshot.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The amount of days until the snapshot is deleted.
         */
        public var snapshotRemainingDays: kotlin.Int? = null
        /**
         * The period of time, in days, of how long the snapshot is retained.
         */
        public var snapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The timestamp of when data within the snapshot started getting retained.
         */
        public var snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the snapshot.
         */
        public var status: aws.sdk.kotlin.services.redshiftserverless.model.SnapshotStatus? = null
        /**
         * The total size, in megabytes, of how big the snapshot is.
         */
        public var totalBackupSizeInMegaBytes: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.Snapshot) : this() {
            this.accountsWithProvisionedRestoreAccess = x.accountsWithProvisionedRestoreAccess
            this.accountsWithRestoreAccess = x.accountsWithRestoreAccess
            this.actualIncrementalBackupSizeInMegaBytes = x.actualIncrementalBackupSizeInMegaBytes
            this.adminUsername = x.adminUsername
            this.backupProgressInMegaBytes = x.backupProgressInMegaBytes
            this.currentBackupRateInMegaBytesPerSecond = x.currentBackupRateInMegaBytesPerSecond
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.estimatedSecondsToCompletion = x.estimatedSecondsToCompletion
            this.kmsKeyId = x.kmsKeyId
            this.namespaceArn = x.namespaceArn
            this.namespaceName = x.namespaceName
            this.ownerAccount = x.ownerAccount
            this.snapshotArn = x.snapshotArn
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotName = x.snapshotName
            this.snapshotRemainingDays = x.snapshotRemainingDays
            this.snapshotRetentionPeriod = x.snapshotRetentionPeriod
            this.snapshotRetentionStartTime = x.snapshotRetentionStartTime
            this.status = x.status
            this.totalBackupSizeInMegaBytes = x.totalBackupSizeInMegaBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.Snapshot = Snapshot(this)
    }
}
