// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The collection of computing resources from which an endpoint is created.
 */
public class Workgroup private constructor(builder: Builder) {
    /**
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    public val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * An array of parameters to set for finer control over a database. The options are `datestyle`, `enable_user_activity_logging`, `query_group`, `search_path`, and `max_query_execution_time`.
     */
    public val configParameters: List<ConfigParameter>? = builder.configParameters
    /**
     * The creation date of the workgroup.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The endpoint that is created from the workgroup.
     */
    public val endpoint: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint? = builder.endpoint
    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * The namespace the workgroup is associated with.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * A value that specifies whether the workgroup can be accessible from a public network
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * An array of security group IDs to associate with the workgroup.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The status of the workgroup.
     */
    public val status: aws.sdk.kotlin.services.redshiftserverless.model.WorkgroupStatus? = builder.status
    /**
     * An array of subnet IDs the workgroup is associated with.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The Amazon Resource Name (ARN) that links to the workgroup.
     */
    public val workgroupArn: kotlin.String? = builder.workgroupArn
    /**
     * The unique identifier of the workgroup.
     */
    public val workgroupId: kotlin.String? = builder.workgroupId
    /**
     * The name of the workgroup.
     */
    public val workgroupName: kotlin.String? = builder.workgroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Workgroup(")
        append("baseCapacity=$baseCapacity,")
        append("configParameters=$configParameters,")
        append("creationDate=$creationDate,")
        append("endpoint=$endpoint,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("namespaceName=$namespaceName,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroupIds=$securityGroupIds,")
        append("status=$status,")
        append("subnetIds=$subnetIds,")
        append("workgroupArn=$workgroupArn,")
        append("workgroupId=$workgroupId,")
        append("workgroupName=$workgroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCapacity ?: 0
        result = 31 * result + (configParameters?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (workgroupArn?.hashCode() ?: 0)
        result = 31 * result + (workgroupId?.hashCode() ?: 0)
        result = 31 * result + (workgroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Workgroup

        if (baseCapacity != other.baseCapacity) return false
        if (configParameters != other.configParameters) return false
        if (creationDate != other.creationDate) return false
        if (endpoint != other.endpoint) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (namespaceName != other.namespaceName) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (status != other.status) return false
        if (subnetIds != other.subnetIds) return false
        if (workgroupArn != other.workgroupArn) return false
        if (workgroupId != other.workgroupId) return false
        if (workgroupName != other.workgroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         */
        public var baseCapacity: kotlin.Int? = null
        /**
         * An array of parameters to set for finer control over a database. The options are `datestyle`, `enable_user_activity_logging`, `query_group`, `search_path`, and `max_query_execution_time`.
         */
        public var configParameters: List<ConfigParameter>? = null
        /**
         * The creation date of the workgroup.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The endpoint that is created from the workgroup.
         */
        public var endpoint: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint? = null
        /**
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * The namespace the workgroup is associated with.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * A value that specifies whether the workgroup can be accessible from a public network
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * An array of security group IDs to associate with the workgroup.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The status of the workgroup.
         */
        public var status: aws.sdk.kotlin.services.redshiftserverless.model.WorkgroupStatus? = null
        /**
         * An array of subnet IDs the workgroup is associated with.
         */
        public var subnetIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) that links to the workgroup.
         */
        public var workgroupArn: kotlin.String? = null
        /**
         * The unique identifier of the workgroup.
         */
        public var workgroupId: kotlin.String? = null
        /**
         * The name of the workgroup.
         */
        public var workgroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshiftserverless.model.Workgroup) : this() {
            this.baseCapacity = x.baseCapacity
            this.configParameters = x.configParameters
            this.creationDate = x.creationDate
            this.endpoint = x.endpoint
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.namespaceName = x.namespaceName
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroupIds = x.securityGroupIds
            this.status = x.status
            this.subnetIds = x.subnetIds
            this.workgroupArn = x.workgroupArn
            this.workgroupId = x.workgroupId
            this.workgroupName = x.workgroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshiftserverless.model.Workgroup = Workgroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshiftserverless.model.Endpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.redshiftserverless.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.redshiftserverless.model.Endpoint.invoke(block)
        }
    }
}
