// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshiftserverless.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.redshiftserverless.model.GetCredentialsResponse
import aws.sdk.kotlin.services.redshiftserverless.model.RedshiftServerlessException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetCredentialsOperationDeserializer: HttpDeserialize<GetCredentialsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCredentialsResponse {
        if (!response.status.isSuccess()) {
            throwGetCredentialsError(context, response)
        }
        val builder = GetCredentialsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCredentialsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCredentialsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RedshiftServerlessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftServerlessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCredentialsOperationBody(builder: GetCredentialsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DBPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dbPassword"))
    val DBUSER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dbUser"))
    val EXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiration"))
    val NEXTREFRESHTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("nextRefreshTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DBPASSWORD_DESCRIPTOR)
        field(DBUSER_DESCRIPTOR)
        field(EXPIRATION_DESCRIPTOR)
        field(NEXTREFRESHTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBPASSWORD_DESCRIPTOR.index -> builder.dbPassword = deserializeString()
                DBUSER_DESCRIPTOR.index -> builder.dbUser = deserializeString()
                EXPIRATION_DESCRIPTOR.index -> builder.expiration = deserializeString().let { Instant.fromEpochSeconds(it) }
                NEXTREFRESHTIME_DESCRIPTOR.index -> builder.nextRefreshTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
