// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.resiliencehub.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.resiliencehub.model.*
import aws.sdk.kotlin.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteRecommendationTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteRecommendationTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAlarmRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAlarmRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentCompliancesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentCompliancesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListRecommendationTemplatesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListRecommendationTemplatesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListResiliencyPoliciesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListResiliencyPoliciesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListSopRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListSopRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListTestRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListTestRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.PublishAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.PublishAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ResolveAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ResolveAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.StartAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.StartAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.TagResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.TagResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.UntagResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.UntagResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Resilience Hub helps you proactively prepare and protect your Amazon Web Services applications from disruptions. Resilience Hub offers continuous resiliency assessment and validation that integrates into your software development lifecycle. This enables you to uncover resiliency weaknesses, ensure recovery time objective (RTO) and recovery point objective (RPO) targets for your applications are met, and resolve issues before they are released into production.
 */
public interface ResiliencehubClient : SdkClient {

    override val serviceName: String
        get() = "resiliencehub"
    /**
     * ResiliencehubClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ResiliencehubClient {
            val config = Config.Builder().apply(block).build()
            return DefaultResiliencehubClient(config)
        }

        public operator fun invoke(config: Config): ResiliencehubClient = DefaultResiliencehubClient(config)

        /**
         * Construct a [ResiliencehubClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ResiliencehubClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultResiliencehubClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds the resource mapping for the draft application version.
     */
    public suspend fun addDraftAppVersionResourceMappings(input: AddDraftAppVersionResourceMappingsRequest): AddDraftAppVersionResourceMappingsResponse

    /**
     * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.
     *
     * After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
     */
    public suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a new recommendation template.
     */
    public suspend fun createRecommendationTemplate(input: CreateRecommendationTemplateRequest): CreateRecommendationTemplateResponse

    /**
     * Creates a resiliency policy for an application.
     */
    public suspend fun createResiliencyPolicy(input: CreateResiliencyPolicyRequest): CreateResiliencyPolicyResponse

    /**
     * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
     */
    public suspend fun deleteAppAssessment(input: DeleteAppAssessmentRequest): DeleteAppAssessmentResponse

    /**
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     */
    public suspend fun deleteRecommendationTemplate(input: DeleteRecommendationTemplateRequest): DeleteRecommendationTemplateResponse

    /**
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     */
    public suspend fun deleteResiliencyPolicy(input: DeleteResiliencyPolicyRequest): DeleteResiliencyPolicyResponse

    /**
     * Describes an AWS Resilience Hub application.
     */
    public suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse

    /**
     * Describes an assessment for an AWS Resilience Hub application.
     */
    public suspend fun describeAppAssessment(input: DescribeAppAssessmentRequest): DescribeAppAssessmentResponse

    /**
     * Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
     */
    public suspend fun describeAppVersionResourcesResolutionStatus(input: DescribeAppVersionResourcesResolutionStatusRequest): DescribeAppVersionResourcesResolutionStatusResponse

    /**
     * Describes details about an AWS Resilience Hub
     */
    public suspend fun describeAppVersionTemplate(input: DescribeAppVersionTemplateRequest): DescribeAppVersionTemplateResponse

    /**
     * Describes the status of importing resources to an application version.
     */
    public suspend fun describeDraftAppVersionResourcesImportStatus(input: DescribeDraftAppVersionResourcesImportStatusRequest): DescribeDraftAppVersionResourcesImportStatusResponse

    /**
     * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
     */
    public suspend fun describeResiliencyPolicy(input: DescribeResiliencyPolicyRequest): DescribeResiliencyPolicyResponse

    /**
     * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.
     */
    public suspend fun importResourcesToDraftAppVersion(input: ImportResourcesToDraftAppVersionRequest): ImportResourcesToDraftAppVersionResponse

    /**
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     */
    public suspend fun listAlarmRecommendations(input: ListAlarmRecommendationsRequest): ListAlarmRecommendationsResponse

    /**
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.
     */
    public suspend fun listAppAssessments(input: ListAppAssessmentsRequest = ListAppAssessmentsRequest {}): ListAppAssessmentsResponse

    /**
     * Lists the compliances for an AWS Resilience Hub component.
     */
    public suspend fun listAppComponentCompliances(input: ListAppComponentCompliancesRequest): ListAppComponentCompliancesResponse

    /**
     * Lists the recommendations for an AWS Resilience Hub component.
     */
    public suspend fun listAppComponentRecommendations(input: ListAppComponentRecommendationsRequest): ListAppComponentRecommendationsResponse

    /**
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     */
    public suspend fun listAppVersionResourceMappings(input: ListAppVersionResourceMappingsRequest): ListAppVersionResourceMappingsResponse

    /**
     * Lists all the resources in an application version.
     */
    public suspend fun listAppVersionResources(input: ListAppVersionResourcesRequest): ListAppVersionResourcesResponse

    /**
     * Lists the different versions for the Resilience Hub applications.
     */
    public suspend fun listAppVersions(input: ListAppVersionsRequest): ListAppVersionsResponse

    /**
     * Lists your Resilience Hub applications.
     */
    public suspend fun listApps(input: ListAppsRequest = ListAppsRequest {}): ListAppsResponse

    /**
     * Lists the recommendation templates for the Resilience Hub applications.
     */
    public suspend fun listRecommendationTemplates(input: ListRecommendationTemplatesRequest): ListRecommendationTemplatesResponse

    /**
     * Lists the resiliency policies for the Resilience Hub applications.
     */
    public suspend fun listResiliencyPolicies(input: ListResiliencyPoliciesRequest = ListResiliencyPoliciesRequest {}): ListResiliencyPoliciesResponse

    /**
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     */
    public suspend fun listSopRecommendations(input: ListSopRecommendationsRequest): ListSopRecommendationsResponse

    /**
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     */
    public suspend fun listSuggestedResiliencyPolicies(input: ListSuggestedResiliencyPoliciesRequest = ListSuggestedResiliencyPoliciesRequest {}): ListSuggestedResiliencyPoliciesResponse

    /**
     * Lists the tags for your resources in your Resilience Hub applications.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the test recommendations for the Resilience Hub application.
     */
    public suspend fun listTestRecommendations(input: ListTestRecommendationsRequest): ListTestRecommendationsResponse

    /**
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     */
    public suspend fun listUnsupportedAppVersionResources(input: ListUnsupportedAppVersionResourcesRequest): ListUnsupportedAppVersionResourcesResponse

    /**
     * Publishes a new version of a specific Resilience Hub application.
     */
    public suspend fun publishAppVersion(input: PublishAppVersionRequest): PublishAppVersionResponse

    /**
     * Adds or updates the app template for a draft version of a Resilience Hub app.
     */
    public suspend fun putDraftAppVersionTemplate(input: PutDraftAppVersionTemplateRequest): PutDraftAppVersionTemplateResponse

    /**
     * Removes resource mappings from a draft application version.
     */
    public suspend fun removeDraftAppVersionResourceMappings(input: RemoveDraftAppVersionResourceMappingsRequest): RemoveDraftAppVersionResourceMappingsResponse

    /**
     * Resolves the resources for an application version.
     */
    public suspend fun resolveAppVersionResources(input: ResolveAppVersionResourcesRequest): ResolveAppVersionResourcesResponse

    /**
     * Creates a new application assessment for an application.
     */
    public suspend fun startAppAssessment(input: StartAppAssessmentRequest): StartAppAssessmentResponse

    /**
     * Applies one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an application.
     */
    public suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse

    /**
     * Updates a resiliency policy.
     */
    public suspend fun updateResiliencyPolicy(input: UpdateResiliencyPolicyRequest): UpdateResiliencyPolicyResponse
}

/**
 * Adds the resource mapping for the draft application version.
 */
public suspend inline fun ResiliencehubClient.addDraftAppVersionResourceMappings(crossinline block: AddDraftAppVersionResourceMappingsRequest.Builder.() -> Unit): AddDraftAppVersionResourceMappingsResponse = addDraftAppVersionResourceMappings(AddDraftAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.
 *
 * After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 */
public suspend inline fun ResiliencehubClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a new recommendation template.
 */
public suspend inline fun ResiliencehubClient.createRecommendationTemplate(crossinline block: CreateRecommendationTemplateRequest.Builder.() -> Unit): CreateRecommendationTemplateResponse = createRecommendationTemplate(CreateRecommendationTemplateRequest.Builder().apply(block).build())

/**
 * Creates a resiliency policy for an application.
 */
public suspend inline fun ResiliencehubClient.createResiliencyPolicy(crossinline block: CreateResiliencyPolicyRequest.Builder.() -> Unit): CreateResiliencyPolicyResponse = createResiliencyPolicy(CreateResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteAppAssessment(crossinline block: DeleteAppAssessmentRequest.Builder.() -> Unit): DeleteAppAssessmentResponse = deleteAppAssessment(DeleteAppAssessmentRequest.Builder().apply(block).build())

/**
 * Deletes a recommendation template. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteRecommendationTemplate(crossinline block: DeleteRecommendationTemplateRequest.Builder.() -> Unit): DeleteRecommendationTemplateResponse = deleteRecommendationTemplate(DeleteRecommendationTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a resiliency policy. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteResiliencyPolicy(crossinline block: DeleteResiliencyPolicyRequest.Builder.() -> Unit): DeleteResiliencyPolicyResponse = deleteResiliencyPolicy(DeleteResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Describes an AWS Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeApp(crossinline block: DescribeAppRequest.Builder.() -> Unit): DescribeAppResponse = describeApp(DescribeAppRequest.Builder().apply(block).build())

/**
 * Describes an assessment for an AWS Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeAppAssessment(crossinline block: DescribeAppAssessmentRequest.Builder.() -> Unit): DescribeAppAssessmentResponse = describeAppAssessment(DescribeAppAssessmentRequest.Builder().apply(block).build())

/**
 * Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
 */
public suspend inline fun ResiliencehubClient.describeAppVersionResourcesResolutionStatus(crossinline block: DescribeAppVersionResourcesResolutionStatusRequest.Builder.() -> Unit): DescribeAppVersionResourcesResolutionStatusResponse = describeAppVersionResourcesResolutionStatus(DescribeAppVersionResourcesResolutionStatusRequest.Builder().apply(block).build())

/**
 * Describes details about an AWS Resilience Hub
 */
public suspend inline fun ResiliencehubClient.describeAppVersionTemplate(crossinline block: DescribeAppVersionTemplateRequest.Builder.() -> Unit): DescribeAppVersionTemplateResponse = describeAppVersionTemplate(DescribeAppVersionTemplateRequest.Builder().apply(block).build())

/**
 * Describes the status of importing resources to an application version.
 */
public suspend inline fun ResiliencehubClient.describeDraftAppVersionResourcesImportStatus(crossinline block: DescribeDraftAppVersionResourcesImportStatusRequest.Builder.() -> Unit): DescribeDraftAppVersionResourcesImportStatusResponse = describeDraftAppVersionResourcesImportStatus(DescribeDraftAppVersionResourcesImportStatusRequest.Builder().apply(block).build())

/**
 * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
 */
public suspend inline fun ResiliencehubClient.describeResiliencyPolicy(crossinline block: DescribeResiliencyPolicyRequest.Builder.() -> Unit): DescribeResiliencyPolicyResponse = describeResiliencyPolicy(DescribeResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.
 */
public suspend inline fun ResiliencehubClient.importResourcesToDraftAppVersion(crossinline block: ImportResourcesToDraftAppVersionRequest.Builder.() -> Unit): ImportResourcesToDraftAppVersionResponse = importResourcesToDraftAppVersion(ImportResourcesToDraftAppVersionRequest.Builder().apply(block).build())

/**
 * Lists the alarm recommendations for a AWS Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listAlarmRecommendations(crossinline block: ListAlarmRecommendationsRequest.Builder.() -> Unit): ListAlarmRecommendationsResponse = listAlarmRecommendations(ListAlarmRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.
 */
public suspend inline fun ResiliencehubClient.listAppAssessments(crossinline block: ListAppAssessmentsRequest.Builder.() -> Unit): ListAppAssessmentsResponse = listAppAssessments(ListAppAssessmentsRequest.Builder().apply(block).build())

/**
 * Lists the compliances for an AWS Resilience Hub component.
 */
public suspend inline fun ResiliencehubClient.listAppComponentCompliances(crossinline block: ListAppComponentCompliancesRequest.Builder.() -> Unit): ListAppComponentCompliancesResponse = listAppComponentCompliances(ListAppComponentCompliancesRequest.Builder().apply(block).build())

/**
 * Lists the recommendations for an AWS Resilience Hub component.
 */
public suspend inline fun ResiliencehubClient.listAppComponentRecommendations(crossinline block: ListAppComponentRecommendationsRequest.Builder.() -> Unit): ListAppComponentRecommendationsResponse = listAppComponentRecommendations(ListAppComponentRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
 */
public suspend inline fun ResiliencehubClient.listAppVersionResourceMappings(crossinline block: ListAppVersionResourceMappingsRequest.Builder.() -> Unit): ListAppVersionResourceMappingsResponse = listAppVersionResourceMappings(ListAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Lists all the resources in an application version.
 */
public suspend inline fun ResiliencehubClient.listAppVersionResources(crossinline block: ListAppVersionResourcesRequest.Builder.() -> Unit): ListAppVersionResourcesResponse = listAppVersionResources(ListAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Lists the different versions for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listAppVersions(crossinline block: ListAppVersionsRequest.Builder.() -> Unit): ListAppVersionsResponse = listAppVersions(ListAppVersionsRequest.Builder().apply(block).build())

/**
 * Lists your Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Lists the recommendation templates for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listRecommendationTemplates(crossinline block: ListRecommendationTemplatesRequest.Builder.() -> Unit): ListRecommendationTemplatesResponse = listRecommendationTemplates(ListRecommendationTemplatesRequest.Builder().apply(block).build())

/**
 * Lists the resiliency policies for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listResiliencyPolicies(crossinline block: ListResiliencyPoliciesRequest.Builder.() -> Unit): ListResiliencyPoliciesResponse = listResiliencyPolicies(ListResiliencyPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listSopRecommendations(crossinline block: ListSopRecommendationsRequest.Builder.() -> Unit): ListSopRecommendationsResponse = listSopRecommendations(ListSopRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the suggested resiliency policies for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listSuggestedResiliencyPolicies(crossinline block: ListSuggestedResiliencyPoliciesRequest.Builder.() -> Unit): ListSuggestedResiliencyPoliciesResponse = listSuggestedResiliencyPolicies(ListSuggestedResiliencyPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the tags for your resources in your Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the test recommendations for the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listTestRecommendations(crossinline block: ListTestRecommendationsRequest.Builder.() -> Unit): ListTestRecommendationsResponse = listTestRecommendations(ListTestRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
 */
public suspend inline fun ResiliencehubClient.listUnsupportedAppVersionResources(crossinline block: ListUnsupportedAppVersionResourcesRequest.Builder.() -> Unit): ListUnsupportedAppVersionResourcesResponse = listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Publishes a new version of a specific Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.publishAppVersion(crossinline block: PublishAppVersionRequest.Builder.() -> Unit): PublishAppVersionResponse = publishAppVersion(PublishAppVersionRequest.Builder().apply(block).build())

/**
 * Adds or updates the app template for a draft version of a Resilience Hub app.
 */
public suspend inline fun ResiliencehubClient.putDraftAppVersionTemplate(crossinline block: PutDraftAppVersionTemplateRequest.Builder.() -> Unit): PutDraftAppVersionTemplateResponse = putDraftAppVersionTemplate(PutDraftAppVersionTemplateRequest.Builder().apply(block).build())

/**
 * Removes resource mappings from a draft application version.
 */
public suspend inline fun ResiliencehubClient.removeDraftAppVersionResourceMappings(crossinline block: RemoveDraftAppVersionResourceMappingsRequest.Builder.() -> Unit): RemoveDraftAppVersionResourceMappingsResponse = removeDraftAppVersionResourceMappings(RemoveDraftAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Resolves the resources for an application version.
 */
public suspend inline fun ResiliencehubClient.resolveAppVersionResources(crossinline block: ResolveAppVersionResourcesRequest.Builder.() -> Unit): ResolveAppVersionResourcesResponse = resolveAppVersionResources(ResolveAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Creates a new application assessment for an application.
 */
public suspend inline fun ResiliencehubClient.startAppAssessment(crossinline block: StartAppAssessmentRequest.Builder.() -> Unit): StartAppAssessmentResponse = startAppAssessment(StartAppAssessmentRequest.Builder().apply(block).build())

/**
 * Applies one or more tags to a resource.
 */
public suspend inline fun ResiliencehubClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a resource.
 */
public suspend inline fun ResiliencehubClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an application.
 */
public suspend inline fun ResiliencehubClient.updateApp(crossinline block: UpdateAppRequest.Builder.() -> Unit): UpdateAppResponse = updateApp(UpdateAppRequest.Builder().apply(block).build())

/**
 * Updates a resiliency policy.
 */
public suspend inline fun ResiliencehubClient.updateResiliencyPolicy(crossinline block: UpdateResiliencyPolicyRequest.Builder.() -> Unit): UpdateResiliencyPolicyResponse = updateResiliencyPolicy(UpdateResiliencyPolicyRequest.Builder().apply(block).build())
