// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application assessment.
 */
public class AppAssessment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * The version of the application.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val assessmentArn: kotlin.String? = builder.assessmentArn
    /**
     * The name of the assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * The current status of the assessment for the resiliency policy.
     */
    public val assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = builder.assessmentStatus
    /**
     * The application compliance against the resiliency policy.
     */
    public val compliance: Map<String, DisruptionCompliance>? = builder.compliance
    /**
     * The current status of the compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = builder.complianceStatus
    /**
     * The cost for the application.
     */
    public val cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = builder.cost
    /**
     * The end time for the action.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The entity that invoked the assessment.
     */
    public val invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = builder.invoker
    /**
     * Error or warning message from the assessment execution
     */
    public val message: kotlin.String? = builder.message
    /**
     * The resiliency policy.
     */
    public val policy: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy? = builder.policy
    /**
     * The current resiliency score for the application.
     */
    public val resiliencyScore: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore? = builder.resiliencyScore
    /**
     * A resource error object containing a list of errors retrieving an application's resources.
     */
    public val resourceErrorsDetails: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails? = builder.resourceErrorsDetails
    /**
     * The starting time for the action.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppAssessment(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("assessmentArn=$assessmentArn,")
        append("assessmentName=$assessmentName,")
        append("assessmentStatus=$assessmentStatus,")
        append("compliance=$compliance,")
        append("complianceStatus=$complianceStatus,")
        append("cost=$cost,")
        append("endTime=$endTime,")
        append("invoker=$invoker,")
        append("message=$message,")
        append("policy=$policy,")
        append("resiliencyScore=$resiliencyScore,")
        append("resourceErrorsDetails=$resourceErrorsDetails,")
        append("startTime=$startTime,")
        append("tags=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (assessmentArn?.hashCode() ?: 0)
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (assessmentStatus?.hashCode() ?: 0)
        result = 31 * result + (compliance?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (cost?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (invoker?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore?.hashCode() ?: 0)
        result = 31 * result + (resourceErrorsDetails?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppAssessment

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (assessmentArn != other.assessmentArn) return false
        if (assessmentName != other.assessmentName) return false
        if (assessmentStatus != other.assessmentStatus) return false
        if (compliance != other.compliance) return false
        if (complianceStatus != other.complianceStatus) return false
        if (cost != other.cost) return false
        if (endTime != other.endTime) return false
        if (invoker != other.invoker) return false
        if (message != other.message) return false
        if (policy != other.policy) return false
        if (resiliencyScore != other.resiliencyScore) return false
        if (resourceErrorsDetails != other.resourceErrorsDetails) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var appArn: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * The name of the assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * The current status of the assessment for the resiliency policy.
         */
        public var assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = null
        /**
         * The application compliance against the resiliency policy.
         */
        public var compliance: Map<String, DisruptionCompliance>? = null
        /**
         * The current status of the compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = null
        /**
         * The cost for the application.
         */
        public var cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = null
        /**
         * The end time for the action.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The entity that invoked the assessment.
         */
        public var invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = null
        /**
         * Error or warning message from the assessment execution
         */
        public var message: kotlin.String? = null
        /**
         * The resiliency policy.
         */
        public var policy: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy? = null
        /**
         * The current resiliency score for the application.
         */
        public var resiliencyScore: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore? = null
        /**
         * A resource error object containing a list of errors retrieving an application's resources.
         */
        public var resourceErrorsDetails: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails? = null
        /**
         * The starting time for the action.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppAssessment) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.assessmentArn = x.assessmentArn
            this.assessmentName = x.assessmentName
            this.assessmentStatus = x.assessmentStatus
            this.compliance = x.compliance
            this.complianceStatus = x.complianceStatus
            this.cost = x.cost
            this.endTime = x.endTime
            this.invoker = x.invoker
            this.message = x.message
            this.policy = x.policy
            this.resiliencyScore = x.resiliencyScore
            this.resourceErrorsDetails = x.resourceErrorsDetails
            this.startTime = x.startTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = AppAssessment(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Cost] inside the given [block]
         */
        public fun cost(block: aws.sdk.kotlin.services.resiliencehub.model.Cost.Builder.() -> kotlin.Unit) {
            this.cost = aws.sdk.kotlin.services.resiliencehub.model.Cost.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy] inside the given [block]
         */
        public fun policy(block: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy.Builder.() -> kotlin.Unit) {
            this.policy = aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore] inside the given [block]
         */
        public fun resiliencyScore(block: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore.Builder.() -> kotlin.Unit) {
            this.resiliencyScore = aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails] inside the given [block]
         */
        public fun resourceErrorsDetails(block: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails.Builder.() -> kotlin.Unit) {
            this.resourceErrorsDetails = aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails.invoke(block)
        }
    }
}
