// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application summary.
 */
public class AppSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * The current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = builder.complianceStatus
    /**
     * The timestamp for when the app was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current resiliency score for the application.
     */
    public val resiliencyScore: kotlin.Double = builder.resiliencyScore
    /**
     * The status of the application.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppSummary(")
        append("appArn=$appArn,")
        append("assessmentSchedule=$assessmentSchedule,")
        append("complianceStatus=$complianceStatus,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("name=$name,")
        append("resiliencyScore=$resiliencyScore,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (assessmentSchedule?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppSummary

        if (appArn != other.appArn) return false
        if (assessmentSchedule != other.assessmentSchedule) return false
        if (complianceStatus != other.complianceStatus) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (resiliencyScore != other.resiliencyScore) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var appArn: kotlin.String? = null
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * The current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = null
        /**
         * The timestamp for when the app was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The current resiliency score for the application.
         */
        public var resiliencyScore: kotlin.Double = 0.0
        /**
         * The status of the application.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppSummary) : this() {
            this.appArn = x.appArn
            this.assessmentSchedule = x.assessmentSchedule
            this.complianceStatus = x.complianceStatus
            this.creationTime = x.creationTime
            this.description = x.description
            this.name = x.name
            this.resiliencyScore = x.resiliencyScore
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = AppSummary(this)
    }
}
