// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



/**
 * Defines a configuration recommendation.
 */
public class ConfigRecommendation private constructor(builder: Builder) {
    /**
     * The application component name.
     */
    public val appComponentName: kotlin.String? = builder.appComponentName
    /**
     * The current compliance against the resiliency policy before applying the configuration change.
     */
    public val compliance: Map<String, DisruptionCompliance>? = builder.compliance
    /**
     * The cost for the application.
     */
    public val cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = builder.cost
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The architecture type.
     */
    public val haArchitecture: aws.sdk.kotlin.services.resiliencehub.model.HaArchitecture? = builder.haArchitecture
    /**
     * The name of the recommendation configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of optimization.
     */
    public val optimizationType: aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendationOptimizationType? = builder.optimizationType
    /**
     * The expected compliance against the resiliency policy after applying the configuration change.
     */
    public val recommendationCompliance: Map<String, RecommendationDisruptionCompliance>? = builder.recommendationCompliance
    /**
     * The reference identifier for the recommendation configuration.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * List of the suggested configuration changes.
     */
    public val suggestedChanges: List<String>? = builder.suggestedChanges

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigRecommendation(")
        append("appComponentName=$appComponentName,")
        append("compliance=$compliance,")
        append("cost=$cost,")
        append("description=$description,")
        append("haArchitecture=$haArchitecture,")
        append("name=$name,")
        append("optimizationType=$optimizationType,")
        append("recommendationCompliance=$recommendationCompliance,")
        append("referenceId=$referenceId,")
        append("suggestedChanges=$suggestedChanges)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponentName?.hashCode() ?: 0
        result = 31 * result + (compliance?.hashCode() ?: 0)
        result = 31 * result + (cost?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (haArchitecture?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (optimizationType?.hashCode() ?: 0)
        result = 31 * result + (recommendationCompliance?.hashCode() ?: 0)
        result = 31 * result + (referenceId?.hashCode() ?: 0)
        result = 31 * result + (suggestedChanges?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigRecommendation

        if (appComponentName != other.appComponentName) return false
        if (compliance != other.compliance) return false
        if (cost != other.cost) return false
        if (description != other.description) return false
        if (haArchitecture != other.haArchitecture) return false
        if (name != other.name) return false
        if (optimizationType != other.optimizationType) return false
        if (recommendationCompliance != other.recommendationCompliance) return false
        if (referenceId != other.referenceId) return false
        if (suggestedChanges != other.suggestedChanges) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The application component name.
         */
        public var appComponentName: kotlin.String? = null
        /**
         * The current compliance against the resiliency policy before applying the configuration change.
         */
        public var compliance: Map<String, DisruptionCompliance>? = null
        /**
         * The cost for the application.
         */
        public var cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * The architecture type.
         */
        public var haArchitecture: aws.sdk.kotlin.services.resiliencehub.model.HaArchitecture? = null
        /**
         * The name of the recommendation configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The type of optimization.
         */
        public var optimizationType: aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendationOptimizationType? = null
        /**
         * The expected compliance against the resiliency policy after applying the configuration change.
         */
        public var recommendationCompliance: Map<String, RecommendationDisruptionCompliance>? = null
        /**
         * The reference identifier for the recommendation configuration.
         */
        public var referenceId: kotlin.String? = null
        /**
         * List of the suggested configuration changes.
         */
        public var suggestedChanges: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendation) : this() {
            this.appComponentName = x.appComponentName
            this.compliance = x.compliance
            this.cost = x.cost
            this.description = x.description
            this.haArchitecture = x.haArchitecture
            this.name = x.name
            this.optimizationType = x.optimizationType
            this.recommendationCompliance = x.recommendationCompliance
            this.referenceId = x.referenceId
            this.suggestedChanges = x.suggestedChanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ConfigRecommendation = ConfigRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Cost] inside the given [block]
         */
        public fun cost(block: aws.sdk.kotlin.services.resiliencehub.model.Cost.Builder.() -> kotlin.Unit) {
            this.cost = aws.sdk.kotlin.services.resiliencehub.model.Cost.invoke(block)
        }
    }
}
