// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



public class UpdateAppRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * Specifies if the resiliency policy ARN should be cleared.
     */
    public val clearResiliencyPolicyArn: kotlin.Boolean? = builder.clearResiliencyPolicyArn
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val policyArn: kotlin.String? = builder.policyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppRequest(")
        append("appArn=$appArn,")
        append("assessmentSchedule=$assessmentSchedule,")
        append("clearResiliencyPolicyArn=$clearResiliencyPolicyArn,")
        append("description=$description,")
        append("policyArn=$policyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (assessmentSchedule?.hashCode() ?: 0)
        result = 31 * result + (clearResiliencyPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppRequest

        if (appArn != other.appArn) return false
        if (assessmentSchedule != other.assessmentSchedule) return false
        if (clearResiliencyPolicyArn != other.clearResiliencyPolicyArn) return false
        if (description != other.description) return false
        if (policyArn != other.policyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var appArn: kotlin.String? = null
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * Specifies if the resiliency policy ARN should be cleared.
         */
        public var clearResiliencyPolicyArn: kotlin.Boolean? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var policyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest) : this() {
            this.appArn = x.appArn
            this.assessmentSchedule = x.assessmentSchedule
            this.clearResiliencyPolicyArn = x.clearResiliencyPolicyArn
            this.description = x.description
            this.policyArn = x.policyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = UpdateAppRequest(this)
    }
}
