// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.robomaker.model.*
import aws.sdk.kotlin.services.robomaker.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "RoboMaker"
public const val ServiceApiVersion: String = "2018-06-29"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultRoboMakerClient(override val config: RoboMakerClient.Config) : RoboMakerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Deletes one or more worlds in a batch operation.
     */
    override suspend fun batchDeleteWorlds(input: BatchDeleteWorldsRequest): BatchDeleteWorldsResponse {
        val op = SdkHttpOperation.build<BatchDeleteWorldsRequest, BatchDeleteWorldsResponse> {
            serializer = BatchDeleteWorldsOperationSerializer()
            deserializer = BatchDeleteWorldsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteWorlds"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more simulation jobs.
     */
    override suspend fun batchDescribeSimulationJob(input: BatchDescribeSimulationJobRequest): BatchDescribeSimulationJobResponse {
        val op = SdkHttpOperation.build<BatchDescribeSimulationJobRequest, BatchDescribeSimulationJobResponse> {
            serializer = BatchDescribeSimulationJobOperationSerializer()
            deserializer = BatchDescribeSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDescribeSimulationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun cancelDeploymentJob(input: CancelDeploymentJobRequest): CancelDeploymentJobResponse {
        val op = SdkHttpOperation.build<CancelDeploymentJobRequest, CancelDeploymentJobResponse> {
            serializer = CancelDeploymentJobOperationSerializer()
            deserializer = CancelDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDeploymentJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified simulation job.
     */
    override suspend fun cancelSimulationJob(input: CancelSimulationJobRequest): CancelSimulationJobResponse {
        val op = SdkHttpOperation.build<CancelSimulationJobRequest, CancelSimulationJobResponse> {
            serializer = CancelSimulationJobOperationSerializer()
            deserializer = CancelSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSimulationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
     */
    override suspend fun cancelSimulationJobBatch(input: CancelSimulationJobBatchRequest): CancelSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<CancelSimulationJobBatchRequest, CancelSimulationJobBatchResponse> {
            serializer = CancelSimulationJobBatchOperationSerializer()
            deserializer = CancelSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSimulationJobBatch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified export job.
     */
    override suspend fun cancelWorldExportJob(input: CancelWorldExportJobRequest): CancelWorldExportJobResponse {
        val op = SdkHttpOperation.build<CancelWorldExportJobRequest, CancelWorldExportJobResponse> {
            serializer = CancelWorldExportJobOperationSerializer()
            deserializer = CancelWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelWorldExportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified world generator job.
     */
    override suspend fun cancelWorldGenerationJob(input: CancelWorldGenerationJobRequest): CancelWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<CancelWorldGenerationJobRequest, CancelWorldGenerationJobResponse> {
            serializer = CancelWorldGenerationJobOperationSerializer()
            deserializer = CancelWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelWorldGenerationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deploys a specific version of a robot application to robots in a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     *
     * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
     *
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createDeploymentJob(input: CreateDeploymentJobRequest): CreateDeploymentJobResponse {
        val op = SdkHttpOperation.build<CreateDeploymentJobRequest, CreateDeploymentJobResponse> {
            serializer = CreateDeploymentJobOperationSerializer()
            deserializer = CreateDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeploymentJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet, a logical group of robots running the same robot application.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a robot.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createRobot(input: CreateRobotRequest): CreateRobotResponse {
        val op = SdkHttpOperation.build<CreateRobotRequest, CreateRobotResponse> {
            serializer = CreateRobotOperationSerializer()
            deserializer = CreateRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a robot application.
     */
    override suspend fun createRobotApplication(input: CreateRobotApplicationRequest): CreateRobotApplicationResponse {
        val op = SdkHttpOperation.build<CreateRobotApplicationRequest, CreateRobotApplicationResponse> {
            serializer = CreateRobotApplicationOperationSerializer()
            deserializer = CreateRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobotApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a version of a robot application.
     */
    override suspend fun createRobotApplicationVersion(input: CreateRobotApplicationVersionRequest): CreateRobotApplicationVersionResponse {
        val op = SdkHttpOperation.build<CreateRobotApplicationVersionRequest, CreateRobotApplicationVersionResponse> {
            serializer = CreateRobotApplicationVersionOperationSerializer()
            deserializer = CreateRobotApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobotApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a simulation application.
     */
    override suspend fun createSimulationApplication(input: CreateSimulationApplicationRequest): CreateSimulationApplicationResponse {
        val op = SdkHttpOperation.build<CreateSimulationApplicationRequest, CreateSimulationApplicationResponse> {
            serializer = CreateSimulationApplicationOperationSerializer()
            deserializer = CreateSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a simulation application with a specific revision id.
     */
    override suspend fun createSimulationApplicationVersion(input: CreateSimulationApplicationVersionRequest): CreateSimulationApplicationVersionResponse {
        val op = SdkHttpOperation.build<CreateSimulationApplicationVersionRequest, CreateSimulationApplicationVersionResponse> {
            serializer = CreateSimulationApplicationVersionOperationSerializer()
            deserializer = CreateSimulationApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a simulation job.
     *
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     */
    override suspend fun createSimulationJob(input: CreateSimulationJobRequest): CreateSimulationJobResponse {
        val op = SdkHttpOperation.build<CreateSimulationJobRequest, CreateSimulationJobResponse> {
            serializer = CreateSimulationJobOperationSerializer()
            deserializer = CreateSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a world export job.
     */
    override suspend fun createWorldExportJob(input: CreateWorldExportJobRequest): CreateWorldExportJobResponse {
        val op = SdkHttpOperation.build<CreateWorldExportJobRequest, CreateWorldExportJobResponse> {
            serializer = CreateWorldExportJobOperationSerializer()
            deserializer = CreateWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldExportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates worlds using the specified template.
     */
    override suspend fun createWorldGenerationJob(input: CreateWorldGenerationJobRequest): CreateWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<CreateWorldGenerationJobRequest, CreateWorldGenerationJobResponse> {
            serializer = CreateWorldGenerationJobOperationSerializer()
            deserializer = CreateWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldGenerationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a world template.
     */
    override suspend fun createWorldTemplate(input: CreateWorldTemplateRequest): CreateWorldTemplateResponse {
        val op = SdkHttpOperation.build<CreateWorldTemplateRequest, CreateWorldTemplateResponse> {
            serializer = CreateWorldTemplateOperationSerializer()
            deserializer = CreateWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse {
        val op = SdkHttpOperation.build<DeleteFleetRequest, DeleteFleetResponse> {
            serializer = DeleteFleetOperationSerializer()
            deserializer = DeleteFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteRobot(input: DeleteRobotRequest): DeleteRobotResponse {
        val op = SdkHttpOperation.build<DeleteRobotRequest, DeleteRobotResponse> {
            serializer = DeleteRobotOperationSerializer()
            deserializer = DeleteRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRobot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a robot application.
     */
    override suspend fun deleteRobotApplication(input: DeleteRobotApplicationRequest): DeleteRobotApplicationResponse {
        val op = SdkHttpOperation.build<DeleteRobotApplicationRequest, DeleteRobotApplicationResponse> {
            serializer = DeleteRobotApplicationOperationSerializer()
            deserializer = DeleteRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRobotApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a simulation application.
     */
    override suspend fun deleteSimulationApplication(input: DeleteSimulationApplicationRequest): DeleteSimulationApplicationResponse {
        val op = SdkHttpOperation.build<DeleteSimulationApplicationRequest, DeleteSimulationApplicationResponse> {
            serializer = DeleteSimulationApplicationOperationSerializer()
            deserializer = DeleteSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSimulationApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a world template.
     */
    override suspend fun deleteWorldTemplate(input: DeleteWorldTemplateRequest): DeleteWorldTemplateResponse {
        val op = SdkHttpOperation.build<DeleteWorldTemplateRequest, DeleteWorldTemplateResponse> {
            serializer = DeleteWorldTemplateOperationSerializer()
            deserializer = DeleteWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorldTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deregisterRobot(input: DeregisterRobotRequest): DeregisterRobotResponse {
        val op = SdkHttpOperation.build<DeregisterRobotRequest, DeregisterRobotResponse> {
            serializer = DeregisterRobotOperationSerializer()
            deserializer = DeregisterRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterRobot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeDeploymentJob(input: DescribeDeploymentJobRequest): DescribeDeploymentJobResponse {
        val op = SdkHttpOperation.build<DescribeDeploymentJobRequest, DescribeDeploymentJobResponse> {
            serializer = DescribeDeploymentJobOperationSerializer()
            deserializer = DescribeDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDeploymentJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeFleet(input: DescribeFleetRequest): DescribeFleetResponse {
        val op = SdkHttpOperation.build<DescribeFleetRequest, DescribeFleetResponse> {
            serializer = DescribeFleetOperationSerializer()
            deserializer = DescribeFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeRobot(input: DescribeRobotRequest): DescribeRobotResponse {
        val op = SdkHttpOperation.build<DescribeRobotRequest, DescribeRobotResponse> {
            serializer = DescribeRobotOperationSerializer()
            deserializer = DescribeRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRobot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a robot application.
     */
    override suspend fun describeRobotApplication(input: DescribeRobotApplicationRequest): DescribeRobotApplicationResponse {
        val op = SdkHttpOperation.build<DescribeRobotApplicationRequest, DescribeRobotApplicationResponse> {
            serializer = DescribeRobotApplicationOperationSerializer()
            deserializer = DescribeRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRobotApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a simulation application.
     */
    override suspend fun describeSimulationApplication(input: DescribeSimulationApplicationRequest): DescribeSimulationApplicationResponse {
        val op = SdkHttpOperation.build<DescribeSimulationApplicationRequest, DescribeSimulationApplicationResponse> {
            serializer = DescribeSimulationApplicationOperationSerializer()
            deserializer = DescribeSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a simulation job.
     */
    override suspend fun describeSimulationJob(input: DescribeSimulationJobRequest): DescribeSimulationJobResponse {
        val op = SdkHttpOperation.build<DescribeSimulationJobRequest, DescribeSimulationJobResponse> {
            serializer = DescribeSimulationJobOperationSerializer()
            deserializer = DescribeSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a simulation job batch.
     */
    override suspend fun describeSimulationJobBatch(input: DescribeSimulationJobBatchRequest): DescribeSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<DescribeSimulationJobBatchRequest, DescribeSimulationJobBatchResponse> {
            serializer = DescribeSimulationJobBatchOperationSerializer()
            deserializer = DescribeSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationJobBatch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a world.
     */
    override suspend fun describeWorld(input: DescribeWorldRequest): DescribeWorldResponse {
        val op = SdkHttpOperation.build<DescribeWorldRequest, DescribeWorldResponse> {
            serializer = DescribeWorldOperationSerializer()
            deserializer = DescribeWorldOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorld"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a world export job.
     */
    override suspend fun describeWorldExportJob(input: DescribeWorldExportJobRequest): DescribeWorldExportJobResponse {
        val op = SdkHttpOperation.build<DescribeWorldExportJobRequest, DescribeWorldExportJobResponse> {
            serializer = DescribeWorldExportJobOperationSerializer()
            deserializer = DescribeWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldExportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a world generation job.
     */
    override suspend fun describeWorldGenerationJob(input: DescribeWorldGenerationJobRequest): DescribeWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<DescribeWorldGenerationJobRequest, DescribeWorldGenerationJobResponse> {
            serializer = DescribeWorldGenerationJobOperationSerializer()
            deserializer = DescribeWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldGenerationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a world template.
     */
    override suspend fun describeWorldTemplate(input: DescribeWorldTemplateRequest): DescribeWorldTemplateResponse {
        val op = SdkHttpOperation.build<DescribeWorldTemplateRequest, DescribeWorldTemplateResponse> {
            serializer = DescribeWorldTemplateOperationSerializer()
            deserializer = DescribeWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the world template body.
     */
    override suspend fun getWorldTemplateBody(input: GetWorldTemplateBodyRequest): GetWorldTemplateBodyResponse {
        val op = SdkHttpOperation.build<GetWorldTemplateBodyRequest, GetWorldTemplateBodyResponse> {
            serializer = GetWorldTemplateBodyOperationSerializer()
            deserializer = GetWorldTemplateBodyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorldTemplateBody"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDeploymentJobs(input: ListDeploymentJobsRequest): ListDeploymentJobsResponse {
        val op = SdkHttpOperation.build<ListDeploymentJobsRequest, ListDeploymentJobsResponse> {
            serializer = ListDeploymentJobsOperationSerializer()
            deserializer = ListDeploymentJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listFleets(input: ListFleetsRequest): ListFleetsResponse {
        val op = SdkHttpOperation.build<ListFleetsRequest, ListFleetsResponse> {
            serializer = ListFleetsOperationSerializer()
            deserializer = ListFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     */
    override suspend fun listRobotApplications(input: ListRobotApplicationsRequest): ListRobotApplicationsResponse {
        val op = SdkHttpOperation.build<ListRobotApplicationsRequest, ListRobotApplicationsResponse> {
            serializer = ListRobotApplicationsOperationSerializer()
            deserializer = ListRobotApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRobotApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listRobots(input: ListRobotsRequest): ListRobotsResponse {
        val op = SdkHttpOperation.build<ListRobotsRequest, ListRobotsResponse> {
            serializer = ListRobotsOperationSerializer()
            deserializer = ListRobotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRobots"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
     */
    override suspend fun listSimulationApplications(input: ListSimulationApplicationsRequest): ListSimulationApplicationsResponse {
        val op = SdkHttpOperation.build<ListSimulationApplicationsRequest, ListSimulationApplicationsResponse> {
            serializer = ListSimulationApplicationsOperationSerializer()
            deserializer = ListSimulationApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
     */
    override suspend fun listSimulationJobBatches(input: ListSimulationJobBatchesRequest): ListSimulationJobBatchesResponse {
        val op = SdkHttpOperation.build<ListSimulationJobBatchesRequest, ListSimulationJobBatchesResponse> {
            serializer = ListSimulationJobBatchesOperationSerializer()
            deserializer = ListSimulationJobBatchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationJobBatches"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     */
    override suspend fun listSimulationJobs(input: ListSimulationJobsRequest): ListSimulationJobsResponse {
        val op = SdkHttpOperation.build<ListSimulationJobsRequest, ListSimulationJobsResponse> {
            serializer = ListSimulationJobsOperationSerializer()
            deserializer = ListSimulationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags on a AWS RoboMaker resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists world export jobs.
     */
    override suspend fun listWorldExportJobs(input: ListWorldExportJobsRequest): ListWorldExportJobsResponse {
        val op = SdkHttpOperation.build<ListWorldExportJobsRequest, ListWorldExportJobsResponse> {
            serializer = ListWorldExportJobsOperationSerializer()
            deserializer = ListWorldExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldExportJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists world generator jobs.
     */
    override suspend fun listWorldGenerationJobs(input: ListWorldGenerationJobsRequest): ListWorldGenerationJobsResponse {
        val op = SdkHttpOperation.build<ListWorldGenerationJobsRequest, ListWorldGenerationJobsResponse> {
            serializer = ListWorldGenerationJobsOperationSerializer()
            deserializer = ListWorldGenerationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldGenerationJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists world templates.
     */
    override suspend fun listWorldTemplates(input: ListWorldTemplatesRequest): ListWorldTemplatesResponse {
        val op = SdkHttpOperation.build<ListWorldTemplatesRequest, ListWorldTemplatesResponse> {
            serializer = ListWorldTemplatesOperationSerializer()
            deserializer = ListWorldTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists worlds.
     */
    override suspend fun listWorlds(input: ListWorldsRequest): ListWorldsResponse {
        val op = SdkHttpOperation.build<ListWorldsRequest, ListWorldsResponse> {
            serializer = ListWorldsOperationSerializer()
            deserializer = ListWorldsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorlds"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers a robot with a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun registerRobot(input: RegisterRobotRequest): RegisterRobotResponse {
        val op = SdkHttpOperation.build<RegisterRobotRequest, RegisterRobotResponse> {
            serializer = RegisterRobotOperationSerializer()
            deserializer = RegisterRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterRobot"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restarts a running simulation job.
     */
    override suspend fun restartSimulationJob(input: RestartSimulationJobRequest): RestartSimulationJobResponse {
        val op = SdkHttpOperation.build<RestartSimulationJobRequest, RestartSimulationJobResponse> {
            serializer = RestartSimulationJobOperationSerializer()
            deserializer = RestartSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestartSimulationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
     */
    override suspend fun startSimulationJobBatch(input: StartSimulationJobBatchRequest): StartSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<StartSimulationJobBatchRequest, StartSimulationJobBatchResponse> {
            serializer = StartSimulationJobBatchOperationSerializer()
            deserializer = StartSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSimulationJobBatch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun syncDeploymentJob(input: SyncDeploymentJobRequest): SyncDeploymentJobResponse {
        val op = SdkHttpOperation.build<SyncDeploymentJobRequest, SyncDeploymentJobResponse> {
            serializer = SyncDeploymentJobOperationSerializer()
            deserializer = SyncDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SyncDeploymentJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or edits tags for a AWS RoboMaker resource.
     *
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
     *
     * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified AWS RoboMaker resource.
     *
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a robot application.
     */
    override suspend fun updateRobotApplication(input: UpdateRobotApplicationRequest): UpdateRobotApplicationResponse {
        val op = SdkHttpOperation.build<UpdateRobotApplicationRequest, UpdateRobotApplicationResponse> {
            serializer = UpdateRobotApplicationOperationSerializer()
            deserializer = UpdateRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRobotApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a simulation application.
     */
    override suspend fun updateSimulationApplication(input: UpdateSimulationApplicationRequest): UpdateSimulationApplicationResponse {
        val op = SdkHttpOperation.build<UpdateSimulationApplicationRequest, UpdateSimulationApplicationResponse> {
            serializer = UpdateSimulationApplicationOperationSerializer()
            deserializer = UpdateSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSimulationApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a world template.
     */
    override suspend fun updateWorldTemplate(input: UpdateWorldTemplateRequest): UpdateWorldTemplateResponse {
        val op = SdkHttpOperation.build<UpdateWorldTemplateRequest, UpdateWorldTemplateResponse> {
            serializer = UpdateWorldTemplateOperationSerializer()
            deserializer = UpdateWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorldTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "robomaker"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "robomaker")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
