// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.robomaker.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.robomaker.model.*
import aws.sdk.kotlin.services.robomaker.model.BatchDeleteWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.BatchDeleteWorldsResponse
import aws.sdk.kotlin.services.robomaker.model.BatchDescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.BatchDescribeSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.CancelWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateFleetRequest
import aws.sdk.kotlin.services.robomaker.model.CreateFleetResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationVersionResponse
import aws.sdk.kotlin.services.robomaker.model.CreateRobotRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationVersionResponse
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.CreateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteFleetResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DeleteWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.DeregisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DeregisterRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeFleetResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldGenerationJobResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldResponse
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldTemplateResponse
import aws.sdk.kotlin.services.robomaker.model.GetWorldTemplateBodyRequest
import aws.sdk.kotlin.services.robomaker.model.GetWorldTemplateBodyResponse
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListFleetsRequest
import aws.sdk.kotlin.services.robomaker.model.ListFleetsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.robomaker.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldsResponse
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotResponse
import aws.sdk.kotlin.services.robomaker.model.RestartSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.RestartSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.TagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.TagResourceResponse
import aws.sdk.kotlin.services.robomaker.model.UntagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.UntagResourceResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateRobotApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateSimulationApplicationResponse
import aws.sdk.kotlin.services.robomaker.model.UpdateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateWorldTemplateResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This section provides documentation for the AWS RoboMaker API operations.
 */
public interface RoboMakerClient : SdkClient {

    override val serviceName: String
        get() = "RoboMaker"
    /**
     * RoboMakerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): RoboMakerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRoboMakerClient(config)
        }

        public operator fun invoke(config: Config): RoboMakerClient = DefaultRoboMakerClient(config)

        /**
         * Construct a [RoboMakerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RoboMakerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRoboMakerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes one or more worlds in a batch operation.
     */
    public suspend fun batchDeleteWorlds(input: BatchDeleteWorldsRequest): BatchDeleteWorldsResponse

    /**
     * Describes one or more simulation jobs.
     */
    public suspend fun batchDescribeSimulationJob(input: BatchDescribeSimulationJobRequest): BatchDescribeSimulationJobResponse

    /**
     * Cancels the specified deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun cancelDeploymentJob(input: CancelDeploymentJobRequest): CancelDeploymentJobResponse

    /**
     * Cancels the specified simulation job.
     */
    public suspend fun cancelSimulationJob(input: CancelSimulationJobRequest): CancelSimulationJobResponse

    /**
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
     */
    public suspend fun cancelSimulationJobBatch(input: CancelSimulationJobBatchRequest): CancelSimulationJobBatchResponse

    /**
     * Cancels the specified export job.
     */
    public suspend fun cancelWorldExportJob(input: CancelWorldExportJobRequest): CancelWorldExportJobResponse

    /**
     * Cancels the specified world generator job.
     */
    public suspend fun cancelWorldGenerationJob(input: CancelWorldGenerationJobRequest): CancelWorldGenerationJobResponse

    /**
     * Deploys a specific version of a robot application to robots in a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     *
     * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
     *
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createDeploymentJob(input: CreateDeploymentJobRequest): CreateDeploymentJobResponse

    /**
     * Creates a fleet, a logical group of robots running the same robot application.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates a robot.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun createRobot(input: CreateRobotRequest): CreateRobotResponse

    /**
     * Creates a robot application.
     */
    public suspend fun createRobotApplication(input: CreateRobotApplicationRequest): CreateRobotApplicationResponse

    /**
     * Creates a version of a robot application.
     */
    public suspend fun createRobotApplicationVersion(input: CreateRobotApplicationVersionRequest): CreateRobotApplicationVersionResponse

    /**
     * Creates a simulation application.
     */
    public suspend fun createSimulationApplication(input: CreateSimulationApplicationRequest): CreateSimulationApplicationResponse

    /**
     * Creates a simulation application with a specific revision id.
     */
    public suspend fun createSimulationApplicationVersion(input: CreateSimulationApplicationVersionRequest): CreateSimulationApplicationVersionResponse

    /**
     * Creates a simulation job.
     *
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     */
    public suspend fun createSimulationJob(input: CreateSimulationJobRequest): CreateSimulationJobResponse

    /**
     * Creates a world export job.
     */
    public suspend fun createWorldExportJob(input: CreateWorldExportJobRequest): CreateWorldExportJobResponse

    /**
     * Creates worlds using the specified template.
     */
    public suspend fun createWorldGenerationJob(input: CreateWorldGenerationJobRequest): CreateWorldGenerationJobResponse

    /**
     * Creates a world template.
     */
    public suspend fun createWorldTemplate(input: CreateWorldTemplateRequest = CreateWorldTemplateRequest {}): CreateWorldTemplateResponse

    /**
     * Deletes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deleteRobot(input: DeleteRobotRequest): DeleteRobotResponse

    /**
     * Deletes a robot application.
     */
    public suspend fun deleteRobotApplication(input: DeleteRobotApplicationRequest): DeleteRobotApplicationResponse

    /**
     * Deletes a simulation application.
     */
    public suspend fun deleteSimulationApplication(input: DeleteSimulationApplicationRequest): DeleteSimulationApplicationResponse

    /**
     * Deletes a world template.
     */
    public suspend fun deleteWorldTemplate(input: DeleteWorldTemplateRequest): DeleteWorldTemplateResponse

    /**
     * Deregisters a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun deregisterRobot(input: DeregisterRobotRequest): DeregisterRobotResponse

    /**
     * Describes a deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeDeploymentJob(input: DescribeDeploymentJobRequest): DescribeDeploymentJobResponse

    /**
     * Describes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeFleet(input: DescribeFleetRequest): DescribeFleetResponse

    /**
     * Describes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun describeRobot(input: DescribeRobotRequest): DescribeRobotResponse

    /**
     * Describes a robot application.
     */
    public suspend fun describeRobotApplication(input: DescribeRobotApplicationRequest): DescribeRobotApplicationResponse

    /**
     * Describes a simulation application.
     */
    public suspend fun describeSimulationApplication(input: DescribeSimulationApplicationRequest): DescribeSimulationApplicationResponse

    /**
     * Describes a simulation job.
     */
    public suspend fun describeSimulationJob(input: DescribeSimulationJobRequest): DescribeSimulationJobResponse

    /**
     * Describes a simulation job batch.
     */
    public suspend fun describeSimulationJobBatch(input: DescribeSimulationJobBatchRequest): DescribeSimulationJobBatchResponse

    /**
     * Describes a world.
     */
    public suspend fun describeWorld(input: DescribeWorldRequest): DescribeWorldResponse

    /**
     * Describes a world export job.
     */
    public suspend fun describeWorldExportJob(input: DescribeWorldExportJobRequest): DescribeWorldExportJobResponse

    /**
     * Describes a world generation job.
     */
    public suspend fun describeWorldGenerationJob(input: DescribeWorldGenerationJobRequest): DescribeWorldGenerationJobResponse

    /**
     * Describes a world template.
     */
    public suspend fun describeWorldTemplate(input: DescribeWorldTemplateRequest): DescribeWorldTemplateResponse

    /**
     * Gets the world template body.
     */
    public suspend fun getWorldTemplateBody(input: GetWorldTemplateBodyRequest = GetWorldTemplateBodyRequest {}): GetWorldTemplateBodyResponse

    /**
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listDeploymentJobs(input: ListDeploymentJobsRequest = ListDeploymentJobsRequest {}): ListDeploymentJobsResponse

    /**
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest {}): ListFleetsResponse

    /**
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     */
    public suspend fun listRobotApplications(input: ListRobotApplicationsRequest = ListRobotApplicationsRequest {}): ListRobotApplicationsResponse

    /**
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun listRobots(input: ListRobotsRequest = ListRobotsRequest {}): ListRobotsResponse

    /**
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
     */
    public suspend fun listSimulationApplications(input: ListSimulationApplicationsRequest = ListSimulationApplicationsRequest {}): ListSimulationApplicationsResponse

    /**
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
     */
    public suspend fun listSimulationJobBatches(input: ListSimulationJobBatchesRequest = ListSimulationJobBatchesRequest {}): ListSimulationJobBatchesResponse

    /**
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     */
    public suspend fun listSimulationJobs(input: ListSimulationJobsRequest = ListSimulationJobsRequest {}): ListSimulationJobsResponse

    /**
     * Lists all tags on a AWS RoboMaker resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists world export jobs.
     */
    public suspend fun listWorldExportJobs(input: ListWorldExportJobsRequest = ListWorldExportJobsRequest {}): ListWorldExportJobsResponse

    /**
     * Lists world generator jobs.
     */
    public suspend fun listWorldGenerationJobs(input: ListWorldGenerationJobsRequest = ListWorldGenerationJobsRequest {}): ListWorldGenerationJobsResponse

    /**
     * Lists world templates.
     */
    public suspend fun listWorldTemplates(input: ListWorldTemplatesRequest = ListWorldTemplatesRequest {}): ListWorldTemplatesResponse

    /**
     * Lists worlds.
     */
    public suspend fun listWorlds(input: ListWorldsRequest = ListWorldsRequest {}): ListWorldsResponse

    /**
     * Registers a robot with a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun registerRobot(input: RegisterRobotRequest): RegisterRobotResponse

    /**
     * Restarts a running simulation job.
     */
    public suspend fun restartSimulationJob(input: RestartSimulationJobRequest): RestartSimulationJobResponse

    /**
     * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
     */
    public suspend fun startSimulationJobBatch(input: StartSimulationJobBatchRequest): StartSimulationJobBatchResponse

    /**
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun syncDeploymentJob(input: SyncDeploymentJobRequest): SyncDeploymentJobResponse

    /**
     * Adds or edits tags for a AWS RoboMaker resource.
     *
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
     *
     * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified AWS RoboMaker resource.
     *
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a robot application.
     */
    public suspend fun updateRobotApplication(input: UpdateRobotApplicationRequest): UpdateRobotApplicationResponse

    /**
     * Updates a simulation application.
     */
    public suspend fun updateSimulationApplication(input: UpdateSimulationApplicationRequest): UpdateSimulationApplicationResponse

    /**
     * Updates a world template.
     */
    public suspend fun updateWorldTemplate(input: UpdateWorldTemplateRequest): UpdateWorldTemplateResponse
}

/**
 * Deletes one or more worlds in a batch operation.
 */
public suspend inline fun RoboMakerClient.batchDeleteWorlds(crossinline block: BatchDeleteWorldsRequest.Builder.() -> Unit): BatchDeleteWorldsResponse = batchDeleteWorlds(BatchDeleteWorldsRequest.Builder().apply(block).build())

/**
 * Describes one or more simulation jobs.
 */
public suspend inline fun RoboMakerClient.batchDescribeSimulationJob(crossinline block: BatchDescribeSimulationJobRequest.Builder.() -> Unit): BatchDescribeSimulationJobResponse = batchDescribeSimulationJob(BatchDescribeSimulationJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified deployment job.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.cancelDeploymentJob(crossinline block: CancelDeploymentJobRequest.Builder.() -> Unit): CancelDeploymentJobResponse = cancelDeploymentJob(CancelDeploymentJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified simulation job.
 */
public suspend inline fun RoboMakerClient.cancelSimulationJob(crossinline block: CancelSimulationJobRequest.Builder.() -> Unit): CancelSimulationJobResponse = cancelSimulationJob(CancelSimulationJobRequest.Builder().apply(block).build())

/**
 * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
 */
public suspend inline fun RoboMakerClient.cancelSimulationJobBatch(crossinline block: CancelSimulationJobBatchRequest.Builder.() -> Unit): CancelSimulationJobBatchResponse = cancelSimulationJobBatch(CancelSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Cancels the specified export job.
 */
public suspend inline fun RoboMakerClient.cancelWorldExportJob(crossinline block: CancelWorldExportJobRequest.Builder.() -> Unit): CancelWorldExportJobResponse = cancelWorldExportJob(CancelWorldExportJobRequest.Builder().apply(block).build())

/**
 * Cancels the specified world generator job.
 */
public suspend inline fun RoboMakerClient.cancelWorldGenerationJob(crossinline block: CancelWorldGenerationJobRequest.Builder.() -> Unit): CancelWorldGenerationJobResponse = cancelWorldGenerationJob(CancelWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Deploys a specific version of a robot application to robots in a fleet.
 *
 * This API is no longer supported and will throw an error if used.
 *
 * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
 *
 * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.createDeploymentJob(crossinline block: CreateDeploymentJobRequest.Builder.() -> Unit): CreateDeploymentJobResponse = createDeploymentJob(CreateDeploymentJobRequest.Builder().apply(block).build())

/**
 * Creates a fleet, a logical group of robots running the same robot application.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Creates a robot.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.createRobot(crossinline block: CreateRobotRequest.Builder.() -> Unit): CreateRobotResponse = createRobot(CreateRobotRequest.Builder().apply(block).build())

/**
 * Creates a robot application.
 */
public suspend inline fun RoboMakerClient.createRobotApplication(crossinline block: CreateRobotApplicationRequest.Builder.() -> Unit): CreateRobotApplicationResponse = createRobotApplication(CreateRobotApplicationRequest.Builder().apply(block).build())

/**
 * Creates a version of a robot application.
 */
public suspend inline fun RoboMakerClient.createRobotApplicationVersion(crossinline block: CreateRobotApplicationVersionRequest.Builder.() -> Unit): CreateRobotApplicationVersionResponse = createRobotApplicationVersion(CreateRobotApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates a simulation application.
 */
public suspend inline fun RoboMakerClient.createSimulationApplication(crossinline block: CreateSimulationApplicationRequest.Builder.() -> Unit): CreateSimulationApplicationResponse = createSimulationApplication(CreateSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Creates a simulation application with a specific revision id.
 */
public suspend inline fun RoboMakerClient.createSimulationApplicationVersion(crossinline block: CreateSimulationApplicationVersionRequest.Builder.() -> Unit): CreateSimulationApplicationVersionResponse = createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates a simulation job.
 *
 * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
 */
public suspend inline fun RoboMakerClient.createSimulationJob(crossinline block: CreateSimulationJobRequest.Builder.() -> Unit): CreateSimulationJobResponse = createSimulationJob(CreateSimulationJobRequest.Builder().apply(block).build())

/**
 * Creates a world export job.
 */
public suspend inline fun RoboMakerClient.createWorldExportJob(crossinline block: CreateWorldExportJobRequest.Builder.() -> Unit): CreateWorldExportJobResponse = createWorldExportJob(CreateWorldExportJobRequest.Builder().apply(block).build())

/**
 * Creates worlds using the specified template.
 */
public suspend inline fun RoboMakerClient.createWorldGenerationJob(crossinline block: CreateWorldGenerationJobRequest.Builder.() -> Unit): CreateWorldGenerationJobResponse = createWorldGenerationJob(CreateWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Creates a world template.
 */
public suspend inline fun RoboMakerClient.createWorldTemplate(crossinline block: CreateWorldTemplateRequest.Builder.() -> Unit): CreateWorldTemplateResponse = createWorldTemplate(CreateWorldTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a fleet.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Deletes a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.deleteRobot(crossinline block: DeleteRobotRequest.Builder.() -> Unit): DeleteRobotResponse = deleteRobot(DeleteRobotRequest.Builder().apply(block).build())

/**
 * Deletes a robot application.
 */
public suspend inline fun RoboMakerClient.deleteRobotApplication(crossinline block: DeleteRobotApplicationRequest.Builder.() -> Unit): DeleteRobotApplicationResponse = deleteRobotApplication(DeleteRobotApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a simulation application.
 */
public suspend inline fun RoboMakerClient.deleteSimulationApplication(crossinline block: DeleteSimulationApplicationRequest.Builder.() -> Unit): DeleteSimulationApplicationResponse = deleteSimulationApplication(DeleteSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a world template.
 */
public suspend inline fun RoboMakerClient.deleteWorldTemplate(crossinline block: DeleteWorldTemplateRequest.Builder.() -> Unit): DeleteWorldTemplateResponse = deleteWorldTemplate(DeleteWorldTemplateRequest.Builder().apply(block).build())

/**
 * Deregisters a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.deregisterRobot(crossinline block: DeregisterRobotRequest.Builder.() -> Unit): DeregisterRobotResponse = deregisterRobot(DeregisterRobotRequest.Builder().apply(block).build())

/**
 * Describes a deployment job.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.describeDeploymentJob(crossinline block: DescribeDeploymentJobRequest.Builder.() -> Unit): DescribeDeploymentJobResponse = describeDeploymentJob(DescribeDeploymentJobRequest.Builder().apply(block).build())

/**
 * Describes a fleet.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.describeFleet(crossinline block: DescribeFleetRequest.Builder.() -> Unit): DescribeFleetResponse = describeFleet(DescribeFleetRequest.Builder().apply(block).build())

/**
 * Describes a robot.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.describeRobot(crossinline block: DescribeRobotRequest.Builder.() -> Unit): DescribeRobotResponse = describeRobot(DescribeRobotRequest.Builder().apply(block).build())

/**
 * Describes a robot application.
 */
public suspend inline fun RoboMakerClient.describeRobotApplication(crossinline block: DescribeRobotApplicationRequest.Builder.() -> Unit): DescribeRobotApplicationResponse = describeRobotApplication(DescribeRobotApplicationRequest.Builder().apply(block).build())

/**
 * Describes a simulation application.
 */
public suspend inline fun RoboMakerClient.describeSimulationApplication(crossinline block: DescribeSimulationApplicationRequest.Builder.() -> Unit): DescribeSimulationApplicationResponse = describeSimulationApplication(DescribeSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Describes a simulation job.
 */
public suspend inline fun RoboMakerClient.describeSimulationJob(crossinline block: DescribeSimulationJobRequest.Builder.() -> Unit): DescribeSimulationJobResponse = describeSimulationJob(DescribeSimulationJobRequest.Builder().apply(block).build())

/**
 * Describes a simulation job batch.
 */
public suspend inline fun RoboMakerClient.describeSimulationJobBatch(crossinline block: DescribeSimulationJobBatchRequest.Builder.() -> Unit): DescribeSimulationJobBatchResponse = describeSimulationJobBatch(DescribeSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Describes a world.
 */
public suspend inline fun RoboMakerClient.describeWorld(crossinline block: DescribeWorldRequest.Builder.() -> Unit): DescribeWorldResponse = describeWorld(DescribeWorldRequest.Builder().apply(block).build())

/**
 * Describes a world export job.
 */
public suspend inline fun RoboMakerClient.describeWorldExportJob(crossinline block: DescribeWorldExportJobRequest.Builder.() -> Unit): DescribeWorldExportJobResponse = describeWorldExportJob(DescribeWorldExportJobRequest.Builder().apply(block).build())

/**
 * Describes a world generation job.
 */
public suspend inline fun RoboMakerClient.describeWorldGenerationJob(crossinline block: DescribeWorldGenerationJobRequest.Builder.() -> Unit): DescribeWorldGenerationJobResponse = describeWorldGenerationJob(DescribeWorldGenerationJobRequest.Builder().apply(block).build())

/**
 * Describes a world template.
 */
public suspend inline fun RoboMakerClient.describeWorldTemplate(crossinline block: DescribeWorldTemplateRequest.Builder.() -> Unit): DescribeWorldTemplateResponse = describeWorldTemplate(DescribeWorldTemplateRequest.Builder().apply(block).build())

/**
 * Gets the world template body.
 */
public suspend inline fun RoboMakerClient.getWorldTemplateBody(crossinline block: GetWorldTemplateBodyRequest.Builder.() -> Unit): GetWorldTemplateBodyResponse = getWorldTemplateBody(GetWorldTemplateBodyRequest.Builder().apply(block).build())

/**
 * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.listDeploymentJobs(crossinline block: ListDeploymentJobsRequest.Builder.() -> Unit): ListDeploymentJobsResponse = listDeploymentJobs(ListDeploymentJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
 */
public suspend inline fun RoboMakerClient.listRobotApplications(crossinline block: ListRobotApplicationsRequest.Builder.() -> Unit): ListRobotApplicationsResponse = listRobotApplications(ListRobotApplicationsRequest.Builder().apply(block).build())

/**
 * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.listRobots(crossinline block: ListRobotsRequest.Builder.() -> Unit): ListRobotsResponse = listRobots(ListRobotsRequest.Builder().apply(block).build())

/**
 * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
 */
public suspend inline fun RoboMakerClient.listSimulationApplications(crossinline block: ListSimulationApplicationsRequest.Builder.() -> Unit): ListSimulationApplicationsResponse = listSimulationApplications(ListSimulationApplicationsRequest.Builder().apply(block).build())

/**
 * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
 */
public suspend inline fun RoboMakerClient.listSimulationJobBatches(crossinline block: ListSimulationJobBatchesRequest.Builder.() -> Unit): ListSimulationJobBatchesResponse = listSimulationJobBatches(ListSimulationJobBatchesRequest.Builder().apply(block).build())

/**
 * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
 */
public suspend inline fun RoboMakerClient.listSimulationJobs(crossinline block: ListSimulationJobsRequest.Builder.() -> Unit): ListSimulationJobsResponse = listSimulationJobs(ListSimulationJobsRequest.Builder().apply(block).build())

/**
 * Lists all tags on a AWS RoboMaker resource.
 */
public suspend inline fun RoboMakerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists world export jobs.
 */
public suspend inline fun RoboMakerClient.listWorldExportJobs(crossinline block: ListWorldExportJobsRequest.Builder.() -> Unit): ListWorldExportJobsResponse = listWorldExportJobs(ListWorldExportJobsRequest.Builder().apply(block).build())

/**
 * Lists world generator jobs.
 */
public suspend inline fun RoboMakerClient.listWorldGenerationJobs(crossinline block: ListWorldGenerationJobsRequest.Builder.() -> Unit): ListWorldGenerationJobsResponse = listWorldGenerationJobs(ListWorldGenerationJobsRequest.Builder().apply(block).build())

/**
 * Lists world templates.
 */
public suspend inline fun RoboMakerClient.listWorldTemplates(crossinline block: ListWorldTemplatesRequest.Builder.() -> Unit): ListWorldTemplatesResponse = listWorldTemplates(ListWorldTemplatesRequest.Builder().apply(block).build())

/**
 * Lists worlds.
 */
public suspend inline fun RoboMakerClient.listWorlds(crossinline block: ListWorldsRequest.Builder.() -> Unit): ListWorldsResponse = listWorlds(ListWorldsRequest.Builder().apply(block).build())

/**
 * Registers a robot with a fleet.
 *
 * This API is no longer supported and will throw an error if used.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.registerRobot(crossinline block: RegisterRobotRequest.Builder.() -> Unit): RegisterRobotResponse = registerRobot(RegisterRobotRequest.Builder().apply(block).build())

/**
 * Restarts a running simulation job.
 */
public suspend inline fun RoboMakerClient.restartSimulationJob(crossinline block: RestartSimulationJobRequest.Builder.() -> Unit): RestartSimulationJobResponse = restartSimulationJob(RestartSimulationJobRequest.Builder().apply(block).build())

/**
 * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
 */
public suspend inline fun RoboMakerClient.startSimulationJobBatch(crossinline block: StartSimulationJobBatchRequest.Builder.() -> Unit): StartSimulationJobBatchResponse = startSimulationJobBatch(StartSimulationJobBatchRequest.Builder().apply(block).build())

/**
 * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
 *
 * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun RoboMakerClient.syncDeploymentJob(crossinline block: SyncDeploymentJobRequest.Builder.() -> Unit): SyncDeploymentJobResponse = syncDeploymentJob(SyncDeploymentJobRequest.Builder().apply(block).build())

/**
 * Adds or edits tags for a AWS RoboMaker resource.
 *
 * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
 *
 * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
 */
public suspend inline fun RoboMakerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified AWS RoboMaker resource.
 *
 * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
 */
public suspend inline fun RoboMakerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a robot application.
 */
public suspend inline fun RoboMakerClient.updateRobotApplication(crossinline block: UpdateRobotApplicationRequest.Builder.() -> Unit): UpdateRobotApplicationResponse = updateRobotApplication(UpdateRobotApplicationRequest.Builder().apply(block).build())

/**
 * Updates a simulation application.
 */
public suspend inline fun RoboMakerClient.updateSimulationApplication(crossinline block: UpdateSimulationApplicationRequest.Builder.() -> Unit): UpdateSimulationApplicationResponse = updateSimulationApplication(UpdateSimulationApplicationRequest.Builder().apply(block).build())

/**
 * Updates a world template.
 */
public suspend inline fun RoboMakerClient.updateWorldTemplate(crossinline block: UpdateWorldTemplateRequest.Builder.() -> Unit): UpdateWorldTemplateResponse = updateWorldTemplate(UpdateWorldTemplateRequest.Builder().apply(block).build())
