// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateWorldGenerationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the world generator job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The time, in milliseconds since the epoch, when the world generator job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The failure code of the world generator job if it failed:
     *
     * ## InternalServiceError
     * Internal service error.
     *
     * ## LimitExceeded
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
     *
     * ## ResourceNotFound
     * The specified resource could not be found.
     *
     * ## RequestThrottled
     * The request was throttled.
     *
     * ## InvalidInput
     * An input parameter in the request is not valid.
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobErrorCode? = builder.failureCode
    /**
     * The status of the world generator job.
     *
     * ## Pending
     * The world generator job request is pending.
     *
     * ## Running
     * The world generator job is running.
     *
     * ## Completed
     * The world generator job completed.
     *
     * ## Failed
     * The world generator job failed. See `failureCode` for more information.
     *
     * ## PartialFailed
     * Some worlds did not generate.
     *
     * ## Canceled
     * The world generator job was cancelled.
     *
     * ## Canceling
     * The world generator job is being cancelled.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobStatus? = builder.status
    /**
     * A map that contains tag keys and tag values that are attached to the world generator job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (arn) of the world template.
     */
    public val template: kotlin.String? = builder.template
    /**
     * Information about the world count.
     */
    public val worldCount: aws.sdk.kotlin.services.robomaker.model.WorldCount? = builder.worldCount
    /**
     * A map that contains tag keys and tag values that are attached to the generated worlds.
     */
    public val worldTags: Map<String, String>? = builder.worldTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorldGenerationJobResponse(")
        append("arn=$arn,")
        append("clientRequestToken=$clientRequestToken,")
        append("createdAt=$createdAt,")
        append("failureCode=$failureCode,")
        append("status=$status,")
        append("tags=$tags,")
        append("template=$template,")
        append("worldCount=$worldCount,")
        append("worldTags=$worldTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (template?.hashCode() ?: 0)
        result = 31 * result + (worldCount?.hashCode() ?: 0)
        result = 31 * result + (worldTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorldGenerationJobResponse

        if (arn != other.arn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (createdAt != other.createdAt) return false
        if (failureCode != other.failureCode) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (template != other.template) return false
        if (worldCount != other.worldCount) return false
        if (worldTags != other.worldTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the world generator job.
         */
        public var arn: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the world generator job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The failure code of the world generator job if it failed:
         *
         * ## InternalServiceError
         * Internal service error.
         *
         * ## LimitExceeded
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
         *
         * ## ResourceNotFound
         * The specified resource could not be found.
         *
         * ## RequestThrottled
         * The request was throttled.
         *
         * ## InvalidInput
         * An input parameter in the request is not valid.
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobErrorCode? = null
        /**
         * The status of the world generator job.
         *
         * ## Pending
         * The world generator job request is pending.
         *
         * ## Running
         * The world generator job is running.
         *
         * ## Completed
         * The world generator job completed.
         *
         * ## Failed
         * The world generator job failed. See `failureCode` for more information.
         *
         * ## PartialFailed
         * Some worlds did not generate.
         *
         * ## Canceled
         * The world generator job was cancelled.
         *
         * ## Canceling
         * The world generator job is being cancelled.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobStatus? = null
        /**
         * A map that contains tag keys and tag values that are attached to the world generator job.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (arn) of the world template.
         */
        public var template: kotlin.String? = null
        /**
         * Information about the world count.
         */
        public var worldCount: aws.sdk.kotlin.services.robomaker.model.WorldCount? = null
        /**
         * A map that contains tag keys and tag values that are attached to the generated worlds.
         */
        public var worldTags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse) : this() {
            this.arn = x.arn
            this.clientRequestToken = x.clientRequestToken
            this.createdAt = x.createdAt
            this.failureCode = x.failureCode
            this.status = x.status
            this.tags = x.tags
            this.template = x.template
            this.worldCount = x.worldCount
            this.worldTags = x.worldTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobResponse = CreateWorldGenerationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.WorldCount] inside the given [block]
         */
        public fun worldCount(block: aws.sdk.kotlin.services.robomaker.model.WorldCount.Builder.() -> kotlin.Unit) {
            this.worldCount = aws.sdk.kotlin.services.robomaker.model.WorldCount.invoke(block)
        }
    }
}
