// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model



public class ListSimulationApplicationsRequest private constructor(builder: Builder) {
    /**
     * Optional list of filters to limit results.
     *
     * The filter name `name` is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * When this parameter is used, `ListSimulationApplications` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListSimulationApplications` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter is not used, then `ListSimulationApplications` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous paginated request did not return all of the remaining results, the response object's `nextToken` parameter value is set to a token. To retrieve the next set of results, call `ListSimulationApplications` again and assign that token to the request object's `nextToken` parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The version qualifier of the simulation application.
     */
    public val versionQualifier: kotlin.String? = builder.versionQualifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSimulationApplicationsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("versionQualifier=$versionQualifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (versionQualifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSimulationApplicationsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (versionQualifier != other.versionQualifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Optional list of filters to limit results.
         *
         * The filter name `name` is supported. When filtering, you must use the complete value of the filtered item. You can use up to three filters.
         */
        public var filters: List<Filter>? = null
        /**
         * When this parameter is used, `ListSimulationApplications` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListSimulationApplications` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter is not used, then `ListSimulationApplications` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous paginated request did not return all of the remaining results, the response object's `nextToken` parameter value is set to a token. To retrieve the next set of results, call `ListSimulationApplications` again and assign that token to the request object's `nextToken` parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The version qualifier of the simulation application.
         */
        public var versionQualifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.versionQualifier = x.versionQualifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest = ListSimulationApplicationsRequest(this)
    }
}
