// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a robot deployment.
 */
public class RobotDeployment private constructor(builder: Builder) {
    /**
     * The robot deployment Amazon Resource Name (ARN).
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time, in milliseconds since the epoch, when the deployment finished.
     */
    public val deploymentFinishTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deploymentFinishTime
    /**
     * The time, in milliseconds since the epoch, when the deployment was started.
     */
    public val deploymentStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deploymentStartTime
    /**
     * The robot deployment failure code.
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.DeploymentJobErrorCode? = builder.failureCode
    /**
     * A short description of the reason why the robot deployment failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * Information about how the deployment is progressing.
     */
    public val progressDetail: aws.sdk.kotlin.services.robomaker.model.ProgressDetail? = builder.progressDetail
    /**
     * The status of the robot deployment.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.RobotStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.RobotDeployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RobotDeployment(")
        append("arn=$arn,")
        append("deploymentFinishTime=$deploymentFinishTime,")
        append("deploymentStartTime=$deploymentStartTime,")
        append("failureCode=$failureCode,")
        append("failureReason=$failureReason,")
        append("progressDetail=$progressDetail,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (deploymentFinishTime?.hashCode() ?: 0)
        result = 31 * result + (deploymentStartTime?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (progressDetail?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RobotDeployment

        if (arn != other.arn) return false
        if (deploymentFinishTime != other.deploymentFinishTime) return false
        if (deploymentStartTime != other.deploymentStartTime) return false
        if (failureCode != other.failureCode) return false
        if (failureReason != other.failureReason) return false
        if (progressDetail != other.progressDetail) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.RobotDeployment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The robot deployment Amazon Resource Name (ARN).
         */
        public var arn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the deployment finished.
         */
        public var deploymentFinishTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in milliseconds since the epoch, when the deployment was started.
         */
        public var deploymentStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The robot deployment failure code.
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.DeploymentJobErrorCode? = null
        /**
         * A short description of the reason why the robot deployment failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * Information about how the deployment is progressing.
         */
        public var progressDetail: aws.sdk.kotlin.services.robomaker.model.ProgressDetail? = null
        /**
         * The status of the robot deployment.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.RobotStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.RobotDeployment) : this() {
            this.arn = x.arn
            this.deploymentFinishTime = x.deploymentFinishTime
            this.deploymentStartTime = x.deploymentStartTime
            this.failureCode = x.failureCode
            this.failureReason = x.failureReason
            this.progressDetail = x.progressDetail
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.RobotDeployment = RobotDeployment(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.ProgressDetail] inside the given [block]
         */
        public fun progressDetail(block: aws.sdk.kotlin.services.robomaker.model.ProgressDetail.Builder.() -> kotlin.Unit) {
            this.progressDetail = aws.sdk.kotlin.services.robomaker.model.ProgressDetail.invoke(block)
        }
    }
}
