// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.paginators

import aws.sdk.kotlin.services.robomaker.RoboMakerClient
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListFleetsRequest
import aws.sdk.kotlin.services.robomaker.model.ListFleetsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListRobotsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesResponse
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesResponse
import aws.sdk.kotlin.services.robomaker.model.ListWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListDeploymentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeploymentJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentJobsResponse]
 */
public fun RoboMakerClient.listDeploymentJobsPaginated(initialRequest: ListDeploymentJobsRequest): Flow<ListDeploymentJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeploymentJobsPaginated.listDeploymentJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDeploymentJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeploymentJobsResponse]
 */
public fun RoboMakerClient.listDeploymentJobsPaginated(block: ListDeploymentJobsRequest.Builder.() -> Unit): Flow<ListDeploymentJobsResponse> =
    listDeploymentJobsPaginated(ListDeploymentJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFleetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun RoboMakerClient.listFleetsPaginated(initialRequest: ListFleetsRequest): Flow<ListFleetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFleetsPaginated.listFleets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFleetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFleetsResponse]
 */
public fun RoboMakerClient.listFleetsPaginated(block: ListFleetsRequest.Builder.() -> Unit): Flow<ListFleetsResponse> =
    listFleetsPaginated(ListFleetsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRobotApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRobotApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotApplicationsResponse]
 */
public fun RoboMakerClient.listRobotApplicationsPaginated(initialRequest: ListRobotApplicationsRequest): Flow<ListRobotApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRobotApplicationsPaginated.listRobotApplications(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRobotApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotApplicationsResponse]
 */
public fun RoboMakerClient.listRobotApplicationsPaginated(block: ListRobotApplicationsRequest.Builder.() -> Unit): Flow<ListRobotApplicationsResponse> =
    listRobotApplicationsPaginated(ListRobotApplicationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRobotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRobotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotsResponse]
 */
public fun RoboMakerClient.listRobotsPaginated(initialRequest: ListRobotsRequest): Flow<ListRobotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRobotsPaginated.listRobots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRobotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRobotsResponse]
 */
public fun RoboMakerClient.listRobotsPaginated(block: ListRobotsRequest.Builder.() -> Unit): Flow<ListRobotsResponse> =
    listRobotsPaginated(ListRobotsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSimulationApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationApplicationsResponse]
 */
public fun RoboMakerClient.listSimulationApplicationsPaginated(initialRequest: ListSimulationApplicationsRequest): Flow<ListSimulationApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationApplicationsPaginated.listSimulationApplications(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationApplicationsResponse]
 */
public fun RoboMakerClient.listSimulationApplicationsPaginated(block: ListSimulationApplicationsRequest.Builder.() -> Unit): Flow<ListSimulationApplicationsResponse> =
    listSimulationApplicationsPaginated(ListSimulationApplicationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSimulationJobBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationJobBatchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobBatchesResponse]
 */
public fun RoboMakerClient.listSimulationJobBatchesPaginated(initialRequest: ListSimulationJobBatchesRequest): Flow<ListSimulationJobBatchesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationJobBatchesPaginated.listSimulationJobBatches(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationJobBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobBatchesResponse]
 */
public fun RoboMakerClient.listSimulationJobBatchesPaginated(block: ListSimulationJobBatchesRequest.Builder.() -> Unit): Flow<ListSimulationJobBatchesResponse> =
    listSimulationJobBatchesPaginated(ListSimulationJobBatchesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSimulationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSimulationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobsResponse]
 */
public fun RoboMakerClient.listSimulationJobsPaginated(initialRequest: ListSimulationJobsRequest): Flow<ListSimulationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSimulationJobsPaginated.listSimulationJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSimulationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSimulationJobsResponse]
 */
public fun RoboMakerClient.listSimulationJobsPaginated(block: ListSimulationJobsRequest.Builder.() -> Unit): Flow<ListSimulationJobsResponse> =
    listSimulationJobsPaginated(ListSimulationJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorldExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldExportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldExportJobsResponse]
 */
public fun RoboMakerClient.listWorldExportJobsPaginated(initialRequest: ListWorldExportJobsRequest): Flow<ListWorldExportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldExportJobsPaginated.listWorldExportJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldExportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldExportJobsResponse]
 */
public fun RoboMakerClient.listWorldExportJobsPaginated(block: ListWorldExportJobsRequest.Builder.() -> Unit): Flow<ListWorldExportJobsResponse> =
    listWorldExportJobsPaginated(ListWorldExportJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorldGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldGenerationJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldGenerationJobsResponse]
 */
public fun RoboMakerClient.listWorldGenerationJobsPaginated(initialRequest: ListWorldGenerationJobsRequest): Flow<ListWorldGenerationJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldGenerationJobsPaginated.listWorldGenerationJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldGenerationJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldGenerationJobsResponse]
 */
public fun RoboMakerClient.listWorldGenerationJobsPaginated(block: ListWorldGenerationJobsRequest.Builder.() -> Unit): Flow<ListWorldGenerationJobsResponse> =
    listWorldGenerationJobsPaginated(ListWorldGenerationJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldsResponse]
 */
public fun RoboMakerClient.listWorldsPaginated(initialRequest: ListWorldsRequest): Flow<ListWorldsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldsPaginated.listWorlds(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldsResponse]
 */
public fun RoboMakerClient.listWorldsPaginated(block: ListWorldsRequest.Builder.() -> Unit): Flow<ListWorldsResponse> =
    listWorldsPaginated(ListWorldsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListWorldTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorldTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldTemplatesResponse]
 */
public fun RoboMakerClient.listWorldTemplatesPaginated(initialRequest: ListWorldTemplatesRequest): Flow<ListWorldTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorldTemplatesPaginated.listWorldTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorldTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorldTemplatesResponse]
 */
public fun RoboMakerClient.listWorldTemplatesPaginated(block: ListWorldTemplatesRequest.Builder.() -> Unit): Flow<ListWorldTemplatesResponse> =
    listWorldTemplatesPaginated(ListWorldTemplatesRequest.Builder().apply(block).build())
