// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.robomaker.model.ComputeResponse
import aws.sdk.kotlin.services.robomaker.model.DataSource
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobResponse
import aws.sdk.kotlin.services.robomaker.model.FailureBehavior
import aws.sdk.kotlin.services.robomaker.model.LoggingConfig
import aws.sdk.kotlin.services.robomaker.model.NetworkInterface
import aws.sdk.kotlin.services.robomaker.model.OutputLocation
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.sdk.kotlin.services.robomaker.model.RobotApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.SimulationJobErrorCode
import aws.sdk.kotlin.services.robomaker.model.SimulationJobStatus
import aws.sdk.kotlin.services.robomaker.model.VpcConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeSimulationJobOperationDeserializer: HttpDeserialize<DescribeSimulationJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSimulationJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSimulationJobError(context, response)
        }
        val builder = DescribeSimulationJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSimulationJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSimulationJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSimulationJobOperationBody(builder: DescribeSimulationJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientRequestToken"))
    val COMPUTE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("compute"))
    val DATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataSources"))
    val FAILUREBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureBehavior"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureCode"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val IAMROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iamRole"))
    val LASTSTARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStartedAt"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val LOGGINGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loggingConfig"))
    val MAXJOBDURATIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("maxJobDurationInSeconds"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NETWORKINTERFACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("networkInterface"))
    val OUTPUTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("outputLocation"))
    val ROBOTAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("robotApplications"))
    val SIMULATIONAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("simulationApplications"))
    val SIMULATIONTIMEMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("simulationTimeMillis"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(COMPUTE_DESCRIPTOR)
        field(DATASOURCES_DESCRIPTOR)
        field(FAILUREBEHAVIOR_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(IAMROLE_DESCRIPTOR)
        field(LASTSTARTEDAT_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(LOGGINGCONFIG_DESCRIPTOR)
        field(MAXJOBDURATIONINSECONDS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NETWORKINTERFACE_DESCRIPTOR)
        field(OUTPUTLOCATION_DESCRIPTOR)
        field(ROBOTAPPLICATIONS_DESCRIPTOR)
        field(SIMULATIONAPPLICATIONS_DESCRIPTOR)
        field(SIMULATIONTIMEMILLIS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CLIENTREQUESTTOKEN_DESCRIPTOR.index -> builder.clientRequestToken = deserializeString()
                COMPUTE_DESCRIPTOR.index -> builder.compute = deserializeComputeResponseDocument(deserializer)
                DATASOURCES_DESCRIPTOR.index -> builder.dataSources =
                    deserializer.deserializeList(DATASOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<DataSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDataSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILUREBEHAVIOR_DESCRIPTOR.index -> builder.failureBehavior = deserializeString().let { FailureBehavior.fromValue(it) }
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString().let { SimulationJobErrorCode.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                IAMROLE_DESCRIPTOR.index -> builder.iamRole = deserializeString()
                LASTSTARTEDAT_DESCRIPTOR.index -> builder.lastStartedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOGGINGCONFIG_DESCRIPTOR.index -> builder.loggingConfig = deserializeLoggingConfigDocument(deserializer)
                MAXJOBDURATIONINSECONDS_DESCRIPTOR.index -> builder.maxJobDurationInSeconds = deserializeLong()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NETWORKINTERFACE_DESCRIPTOR.index -> builder.networkInterface = deserializeNetworkInterfaceDocument(deserializer)
                OUTPUTLOCATION_DESCRIPTOR.index -> builder.outputLocation = deserializeOutputLocationDocument(deserializer)
                ROBOTAPPLICATIONS_DESCRIPTOR.index -> builder.robotApplications =
                    deserializer.deserializeList(ROBOTAPPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RobotApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRobotApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SIMULATIONAPPLICATIONS_DESCRIPTOR.index -> builder.simulationApplications =
                    deserializer.deserializeList(SIMULATIONAPPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<SimulationApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSimulationApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SIMULATIONTIMEMILLIS_DESCRIPTOR.index -> builder.simulationTimeMillis = deserializeLong()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SimulationJobStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCCONFIG_DESCRIPTOR.index -> builder.vpcConfig = deserializeVpcConfigResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
