// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotResponse
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterRobotOperationDeserializer: HttpDeserialize<RegisterRobotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterRobotResponse {
        if (!response.status.isSuccess()) {
            throwRegisterRobotError(context, response)
        }
        val builder = RegisterRobotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterRobotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterRobotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterRobotOperationBody(builder: RegisterRobotResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FLEET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fleet"))
    val ROBOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("robot"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FLEET_DESCRIPTOR)
        field(ROBOT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FLEET_DESCRIPTOR.index -> builder.fleet = deserializeString()
                ROBOT_DESCRIPTOR.index -> builder.robot = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
