// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.route53domains.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.route53domains.model.*
import aws.sdk.kotlin.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountRequest
import aws.sdk.kotlin.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountResponse
import aws.sdk.kotlin.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountRequest
import aws.sdk.kotlin.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountResponse
import aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityRequest
import aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityResponse
import aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityRequest
import aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityResponse
import aws.sdk.kotlin.services.route53domains.model.DeleteDomainRequest
import aws.sdk.kotlin.services.route53domains.model.DeleteDomainResponse
import aws.sdk.kotlin.services.route53domains.model.DeleteTagsForDomainRequest
import aws.sdk.kotlin.services.route53domains.model.DeleteTagsForDomainResponse
import aws.sdk.kotlin.services.route53domains.model.DisableDomainAutoRenewRequest
import aws.sdk.kotlin.services.route53domains.model.DisableDomainAutoRenewResponse
import aws.sdk.kotlin.services.route53domains.model.DisableDomainTransferLockRequest
import aws.sdk.kotlin.services.route53domains.model.DisableDomainTransferLockResponse
import aws.sdk.kotlin.services.route53domains.model.EnableDomainAutoRenewRequest
import aws.sdk.kotlin.services.route53domains.model.EnableDomainAutoRenewResponse
import aws.sdk.kotlin.services.route53domains.model.EnableDomainTransferLockRequest
import aws.sdk.kotlin.services.route53domains.model.EnableDomainTransferLockResponse
import aws.sdk.kotlin.services.route53domains.model.GetContactReachabilityStatusRequest
import aws.sdk.kotlin.services.route53domains.model.GetContactReachabilityStatusResponse
import aws.sdk.kotlin.services.route53domains.model.GetDomainDetailRequest
import aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse
import aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsRequest
import aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsResponse
import aws.sdk.kotlin.services.route53domains.model.GetOperationDetailRequest
import aws.sdk.kotlin.services.route53domains.model.GetOperationDetailResponse
import aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest
import aws.sdk.kotlin.services.route53domains.model.ListDomainsResponse
import aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest
import aws.sdk.kotlin.services.route53domains.model.ListOperationsResponse
import aws.sdk.kotlin.services.route53domains.model.ListPricesRequest
import aws.sdk.kotlin.services.route53domains.model.ListPricesResponse
import aws.sdk.kotlin.services.route53domains.model.ListTagsForDomainRequest
import aws.sdk.kotlin.services.route53domains.model.ListTagsForDomainResponse
import aws.sdk.kotlin.services.route53domains.model.RegisterDomainRequest
import aws.sdk.kotlin.services.route53domains.model.RegisterDomainResponse
import aws.sdk.kotlin.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountRequest
import aws.sdk.kotlin.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountResponse
import aws.sdk.kotlin.services.route53domains.model.RenewDomainRequest
import aws.sdk.kotlin.services.route53domains.model.RenewDomainResponse
import aws.sdk.kotlin.services.route53domains.model.ResendContactReachabilityEmailRequest
import aws.sdk.kotlin.services.route53domains.model.ResendContactReachabilityEmailResponse
import aws.sdk.kotlin.services.route53domains.model.RetrieveDomainAuthCodeRequest
import aws.sdk.kotlin.services.route53domains.model.RetrieveDomainAuthCodeResponse
import aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest
import aws.sdk.kotlin.services.route53domains.model.TransferDomainResponse
import aws.sdk.kotlin.services.route53domains.model.TransferDomainToAnotherAwsAccountRequest
import aws.sdk.kotlin.services.route53domains.model.TransferDomainToAnotherAwsAccountResponse
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainContactPrivacyRequest
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainContactPrivacyResponse
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainContactRequest
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainContactResponse
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversRequest
import aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversResponse
import aws.sdk.kotlin.services.route53domains.model.UpdateTagsForDomainRequest
import aws.sdk.kotlin.services.route53domains.model.UpdateTagsForDomainResponse
import aws.sdk.kotlin.services.route53domains.model.ViewBillingRequest
import aws.sdk.kotlin.services.route53domains.model.ViewBillingResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Route 53 API actions let you register domain names and perform related operations.
 */
public interface Route53DomainsClient : SdkClient {

    override val serviceName: String
        get() = "Route 53 Domains"
    /**
     * Route53DomainsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Route53DomainsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRoute53DomainsClient(config)
        }

        public operator fun invoke(config: Config): Route53DomainsClient = DefaultRoute53DomainsClient(config)

        /**
         * Construct a [Route53DomainsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Route53DomainsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRoute53DomainsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services account. You initiate a transfer between Amazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * If you use the CLI command at [accept-domain-transfer-from-another-aws-account](https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html), use JSON format as input instead of text because otherwise CLI will throw an error from domain transfer input that includes single quotes.
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    public suspend fun acceptDomainTransferFromAnotherAwsAccount(input: AcceptDomainTransferFromAnotherAwsAccountRequest): AcceptDomainTransferFromAnotherAwsAccountResponse

    /**
     * Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * You must cancel the transfer before the other Amazon Web Services account accepts the transfer using [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    public suspend fun cancelDomainTransferToAnotherAwsAccount(input: CancelDomainTransferToAnotherAwsAccountRequest): CancelDomainTransferToAnotherAwsAccountResponse

    /**
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.
     */
    public suspend fun checkDomainAvailability(input: CheckDomainAvailabilityRequest): CheckDomainAvailabilityResponse

    /**
     * Checks whether a domain name can be transferred to Amazon Route 53.
     */
    public suspend fun checkDomainTransferability(input: CheckDomainTransferabilityRequest): CheckDomainTransferabilityResponse

    /**
     * This operation deletes the specified domain. This action is permanent. For more information, see [Deleting a domain name registration](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html).
     *
     * To transfer the domain registration to another registrar, use the transfer process that’s provided by the registrar to which you want to transfer the registration. Otherwise, the following apply:
     * + You can’t get a refund for the cost of a deleted domain registration.
     * + The registry for the top-level domain might hold the domain name for a brief time before releasing it for other users to register (varies by registry).
     * + When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will come from `noreply@domainnameverification.net` or `noreply@registrar.amazon.com`.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * This operation deletes the specified tags for a domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    public suspend fun deleteTagsForDomain(input: DeleteTagsForDomainRequest): DeleteTagsForDomainResponse

    /**
     * This operation disables automatic renewal of domain registration for the specified domain.
     */
    public suspend fun disableDomainAutoRenew(input: DisableDomainAutoRenewRequest): DisableDomainAutoRenewResponse

    /**
     * This operation removes the transfer lock on the domain (specifically the `clientTransferProhibited` status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    public suspend fun disableDomainTransferLock(input: DisableDomainTransferLockRequest): DisableDomainTransferLockResponse

    /**
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services account.
     *
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see [Domains That You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*. Route 53 requires that you renew before the end of the renewal period so we can complete processing before the deadline.
     */
    public suspend fun enableDomainAutoRenew(input: EnableDomainAutoRenewRequest): EnableDomainAutoRenewResponse

    /**
     * This operation sets the transfer lock on the domain (specifically the `clientTransferProhibited` status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    public suspend fun enableDomainTransferLock(input: EnableDomainTransferLockRequest): EnableDomainTransferLockResponse

    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.
     *
     * If you want us to resend the email, use the `ResendContactReachabilityEmail` operation.
     */
    public suspend fun getContactReachabilityStatus(input: GetContactReachabilityStatusRequest = GetContactReachabilityStatusRequest {}): GetContactReachabilityStatusResponse

    /**
     * This operation returns detailed information about a specified domain that is associated with the current Amazon Web Services account. Contact information for the domain is also returned as part of the output.
     */
    public suspend fun getDomainDetail(input: GetDomainDetailRequest): GetDomainDetailResponse

    /**
     * The GetDomainSuggestions operation returns a list of suggested domain names.
     */
    public suspend fun getDomainSuggestions(input: GetDomainSuggestionsRequest): GetDomainSuggestionsResponse

    /**
     * This operation returns the current status of an operation that is not completed.
     */
    public suspend fun getOperationDetail(input: GetOperationDetailRequest): GetOperationDetailResponse

    /**
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account.
     *
     * This command runs only in the us-east-1 Region.
     */
    public suspend fun listOperations(input: ListOperationsRequest = ListOperationsRequest {}): ListOperationsResponse

    /**
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * + Registration
     * + Transfer
     * + Owner change
     * + Domain renewal
     * + Domain restoration
     */
    public suspend fun listPrices(input: ListPricesRequest = ListPricesRequest {}): ListPricesResponse

    /**
     * This operation returns all of the tags that are associated with the specified domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    public suspend fun listTagsForDomain(input: ListTagsForDomainRequest): ListTagsForDomainResponse

    /**
     * This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters.
     *
     * When you register a domain, Amazon Route 53 does the following:
     * + Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.
     * + Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of the renewal date so you can choose whether to renew the registration.
     * + Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy protection, WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     * + If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.
     * + Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see [Amazon Route 53 Pricing](http://aws.amazon.com/route53/pricing/).
     */
    public suspend fun registerDomain(input: RegisterDomainRequest): RegisterDomainResponse

    /**
     * Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    public suspend fun rejectDomainTransferFromAnotherAwsAccount(input: RejectDomainTransferFromAnotherAwsAccountRequest): RejectDomainTransferFromAnotherAwsAccountResponse

    /**
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your Amazon Web Services account.
     *
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see [Renewing Registration for a Domain](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html) in the *Amazon Route 53 Developer Guide*.
     */
    public suspend fun renewDomain(input: RenewDomainRequest): RenewDomainResponse

    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.
     */
    public suspend fun resendContactReachabilityEmail(input: ResendContactReachabilityEmailRequest = ResendContactReachabilityEmailRequest {}): ResendContactReachabilityEmailResponse

    /**
     * This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.
     */
    public suspend fun retrieveDomainAuthCode(input: RetrieveDomainAuthCodeRequest): RetrieveDomainAuthCodeResponse

    /**
     * Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).
     *
     * For more information about transferring domains, see the following topics:
     * + For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring to Route 53, see [Transferring Registration for a Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html) in the *Amazon Route 53 Developer Guide*.
     * + For information about how to transfer a domain from one Amazon Web Services account to another, see [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     * + For information about how to transfer a domain to another domain registrar, see [Transferring a Domain from Amazon Route 53 to Another Registrar](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html) in the *Amazon Route 53 Developer Guide*.
     *
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.
     *
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.
     *
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.
     */
    public suspend fun transferDomain(input: TransferDomainRequest): TransferDomainResponse

    /**
     * Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the following:
     * + The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other account doesn't accept the transfer within 3 days, we cancel the transfer. See [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
     * + You can cancel the transfer before the other account accepts it. See [CancelDomainTransferToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html).
     * + The other account can reject the transfer. See [RejectDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html).
     *
     * When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the hosted zone to another Amazon Web Services account, see [Migrating a Hosted Zone to a Different Amazon Web Services Account](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html) in the *Amazon Route 53 Developer Guide*.
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    public suspend fun transferDomainToAnotherAwsAccount(input: TransferDomainToAnotherAwsAccountRequest): TransferDomainToAnotherAwsAccountResponse

    /**
     * This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical.
     *
     * If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    public suspend fun updateDomainContact(input: UpdateDomainContactRequest): UpdateDomainContactResponse

    /**
     * This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org domains) or with contact information for our registrar associate, Gandi.
     *
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *
     * This operation affects only the contact information for the specified contact type (administrative, registrant, or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.
     *
     * By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection using either `UpdateDomainContactPrivacy` or the Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database. For more information on our privacy practices, see [https://aws.amazon.com/privacy/](https://aws.amazon.com/privacy/).
     */
    public suspend fun updateDomainContactPrivacy(input: UpdateDomainContactPrivacyRequest): UpdateDomainContactPrivacyResponse

    /**
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
     *
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    public suspend fun updateDomainNameservers(input: UpdateDomainNameserversRequest): UpdateDomainNameserversResponse

    /**
     * This operation adds or updates tags for a specified domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    public suspend fun updateTagsForDomain(input: UpdateTagsForDomainRequest): UpdateTagsForDomainResponse

    /**
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     */
    public suspend fun viewBilling(input: ViewBillingRequest = ViewBillingRequest {}): ViewBillingResponse
}

/**
 * Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services account. You initiate a transfer between Amazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
 *
 * If you use the CLI command at [accept-domain-transfer-from-another-aws-account](https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html), use JSON format as input instead of text because otherwise CLI will throw an error from domain transfer input that includes single quotes.
 *
 * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
 */
public suspend inline fun Route53DomainsClient.acceptDomainTransferFromAnotherAwsAccount(crossinline block: AcceptDomainTransferFromAnotherAwsAccountRequest.Builder.() -> Unit): AcceptDomainTransferFromAnotherAwsAccountResponse = acceptDomainTransferFromAnotherAwsAccount(AcceptDomainTransferFromAnotherAwsAccountRequest.Builder().apply(block).build())

/**
 * Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
 *
 * You must cancel the transfer before the other Amazon Web Services account accepts the transfer using [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
 *
 * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
 */
public suspend inline fun Route53DomainsClient.cancelDomainTransferToAnotherAwsAccount(crossinline block: CancelDomainTransferToAnotherAwsAccountRequest.Builder.() -> Unit): CancelDomainTransferToAnotherAwsAccountResponse = cancelDomainTransferToAnotherAwsAccount(CancelDomainTransferToAnotherAwsAccountRequest.Builder().apply(block).build())

/**
 * This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.
 */
public suspend inline fun Route53DomainsClient.checkDomainAvailability(crossinline block: CheckDomainAvailabilityRequest.Builder.() -> Unit): CheckDomainAvailabilityResponse = checkDomainAvailability(CheckDomainAvailabilityRequest.Builder().apply(block).build())

/**
 * Checks whether a domain name can be transferred to Amazon Route 53.
 */
public suspend inline fun Route53DomainsClient.checkDomainTransferability(crossinline block: CheckDomainTransferabilityRequest.Builder.() -> Unit): CheckDomainTransferabilityResponse = checkDomainTransferability(CheckDomainTransferabilityRequest.Builder().apply(block).build())

/**
 * This operation deletes the specified domain. This action is permanent. For more information, see [Deleting a domain name registration](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html).
 *
 * To transfer the domain registration to another registrar, use the transfer process that’s provided by the registrar to which you want to transfer the registration. Otherwise, the following apply:
 * + You can’t get a refund for the cost of a deleted domain registration.
 * + The registry for the top-level domain might hold the domain name for a brief time before releasing it for other users to register (varies by registry).
 * + When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will come from `noreply@domainnameverification.net` or `noreply@registrar.amazon.com`.
 */
public suspend inline fun Route53DomainsClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * This operation deletes the specified tags for a domain.
 *
 * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
 */
public suspend inline fun Route53DomainsClient.deleteTagsForDomain(crossinline block: DeleteTagsForDomainRequest.Builder.() -> Unit): DeleteTagsForDomainResponse = deleteTagsForDomain(DeleteTagsForDomainRequest.Builder().apply(block).build())

/**
 * This operation disables automatic renewal of domain registration for the specified domain.
 */
public suspend inline fun Route53DomainsClient.disableDomainAutoRenew(crossinline block: DisableDomainAutoRenewRequest.Builder.() -> Unit): DisableDomainAutoRenewResponse = disableDomainAutoRenew(DisableDomainAutoRenewRequest.Builder().apply(block).build())

/**
 * This operation removes the transfer lock on the domain (specifically the `clientTransferProhibited` status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
 */
public suspend inline fun Route53DomainsClient.disableDomainTransferLock(crossinline block: DisableDomainTransferLockRequest.Builder.() -> Unit): DisableDomainTransferLockResponse = disableDomainTransferLock(DisableDomainTransferLockRequest.Builder().apply(block).build())

/**
 * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services account.
 *
 * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see [Domains That You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*. Route 53 requires that you renew before the end of the renewal period so we can complete processing before the deadline.
 */
public suspend inline fun Route53DomainsClient.enableDomainAutoRenew(crossinline block: EnableDomainAutoRenewRequest.Builder.() -> Unit): EnableDomainAutoRenewResponse = enableDomainAutoRenew(EnableDomainAutoRenewRequest.Builder().apply(block).build())

/**
 * This operation sets the transfer lock on the domain (specifically the `clientTransferProhibited` status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
 */
public suspend inline fun Route53DomainsClient.enableDomainTransferLock(crossinline block: EnableDomainTransferLockRequest.Builder.() -> Unit): EnableDomainTransferLockResponse = enableDomainTransferLock(EnableDomainTransferLockRequest.Builder().apply(block).build())

/**
 * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.
 *
 * If you want us to resend the email, use the `ResendContactReachabilityEmail` operation.
 */
public suspend inline fun Route53DomainsClient.getContactReachabilityStatus(crossinline block: GetContactReachabilityStatusRequest.Builder.() -> Unit): GetContactReachabilityStatusResponse = getContactReachabilityStatus(GetContactReachabilityStatusRequest.Builder().apply(block).build())

/**
 * This operation returns detailed information about a specified domain that is associated with the current Amazon Web Services account. Contact information for the domain is also returned as part of the output.
 */
public suspend inline fun Route53DomainsClient.getDomainDetail(crossinline block: GetDomainDetailRequest.Builder.() -> Unit): GetDomainDetailResponse = getDomainDetail(GetDomainDetailRequest.Builder().apply(block).build())

/**
 * The GetDomainSuggestions operation returns a list of suggested domain names.
 */
public suspend inline fun Route53DomainsClient.getDomainSuggestions(crossinline block: GetDomainSuggestionsRequest.Builder.() -> Unit): GetDomainSuggestionsResponse = getDomainSuggestions(GetDomainSuggestionsRequest.Builder().apply(block).build())

/**
 * This operation returns the current status of an operation that is not completed.
 */
public suspend inline fun Route53DomainsClient.getOperationDetail(crossinline block: GetOperationDetailRequest.Builder.() -> Unit): GetOperationDetailResponse = getOperationDetail(GetOperationDetailRequest.Builder().apply(block).build())

/**
 * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.
 */
public suspend inline fun Route53DomainsClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account.
 *
 * This command runs only in the us-east-1 Region.
 */
public suspend inline fun Route53DomainsClient.listOperations(crossinline block: ListOperationsRequest.Builder.() -> Unit): ListOperationsResponse = listOperations(ListOperationsRequest.Builder().apply(block).build())

/**
 * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
 * + Registration
 * + Transfer
 * + Owner change
 * + Domain renewal
 * + Domain restoration
 */
public suspend inline fun Route53DomainsClient.listPrices(crossinline block: ListPricesRequest.Builder.() -> Unit): ListPricesResponse = listPrices(ListPricesRequest.Builder().apply(block).build())

/**
 * This operation returns all of the tags that are associated with the specified domain.
 *
 * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
 */
public suspend inline fun Route53DomainsClient.listTagsForDomain(crossinline block: ListTagsForDomainRequest.Builder.() -> Unit): ListTagsForDomainResponse = listTagsForDomain(ListTagsForDomainRequest.Builder().apply(block).build())

/**
 * This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters.
 *
 * When you register a domain, Amazon Route 53 does the following:
 * + Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.
 * + Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of the renewal date so you can choose whether to renew the registration.
 * + Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy protection, WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.You must specify the same privacy setting for the administrative, registrant, and technical contacts.
 * + If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.
 * + Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see [Amazon Route 53 Pricing](http://aws.amazon.com/route53/pricing/).
 */
public suspend inline fun Route53DomainsClient.registerDomain(crossinline block: RegisterDomainRequest.Builder.() -> Unit): RegisterDomainResponse = registerDomain(RegisterDomainRequest.Builder().apply(block).build())

/**
 * Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
 *
 * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
 */
public suspend inline fun Route53DomainsClient.rejectDomainTransferFromAnotherAwsAccount(crossinline block: RejectDomainTransferFromAnotherAwsAccountRequest.Builder.() -> Unit): RejectDomainTransferFromAnotherAwsAccountResponse = rejectDomainTransferFromAnotherAwsAccount(RejectDomainTransferFromAnotherAwsAccountRequest.Builder().apply(block).build())

/**
 * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your Amazon Web Services account.
 *
 * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see [Renewing Registration for a Domain](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html) in the *Amazon Route 53 Developer Guide*.
 */
public suspend inline fun Route53DomainsClient.renewDomain(crossinline block: RenewDomainRequest.Builder.() -> Unit): RenewDomainResponse = renewDomain(RenewDomainRequest.Builder().apply(block).build())

/**
 * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.
 */
public suspend inline fun Route53DomainsClient.resendContactReachabilityEmail(crossinline block: ResendContactReachabilityEmailRequest.Builder.() -> Unit): ResendContactReachabilityEmailResponse = resendContactReachabilityEmail(ResendContactReachabilityEmailRequest.Builder().apply(block).build())

/**
 * This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.
 */
public suspend inline fun Route53DomainsClient.retrieveDomainAuthCode(crossinline block: RetrieveDomainAuthCodeRequest.Builder.() -> Unit): RetrieveDomainAuthCodeResponse = retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest.Builder().apply(block).build())

/**
 * Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).
 *
 * For more information about transferring domains, see the following topics:
 * + For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring to Route 53, see [Transferring Registration for a Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html) in the *Amazon Route 53 Developer Guide*.
 * + For information about how to transfer a domain from one Amazon Web Services account to another, see [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
 * + For information about how to transfer a domain to another domain registrar, see [Transferring a Domain from Amazon Route 53 to Another Registrar](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html) in the *Amazon Route 53 Developer Guide*.
 *
 * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.
 *
 * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.
 *
 * If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.
 */
public suspend inline fun Route53DomainsClient.transferDomain(crossinline block: TransferDomainRequest.Builder.() -> Unit): TransferDomainResponse = transferDomain(TransferDomainRequest.Builder().apply(block).build())

/**
 * Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the following:
 * + The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other account doesn't accept the transfer within 3 days, we cancel the transfer. See [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
 * + You can cancel the transfer before the other account accepts it. See [CancelDomainTransferToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html).
 * + The other account can reject the transfer. See [RejectDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html).
 *
 * When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the hosted zone to another Amazon Web Services account, see [Migrating a Hosted Zone to a Different Amazon Web Services Account](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html) in the *Amazon Route 53 Developer Guide*.
 *
 * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
 */
public suspend inline fun Route53DomainsClient.transferDomainToAnotherAwsAccount(crossinline block: TransferDomainToAnotherAwsAccountRequest.Builder.() -> Unit): TransferDomainToAnotherAwsAccountResponse = transferDomainToAnotherAwsAccount(TransferDomainToAnotherAwsAccountRequest.Builder().apply(block).build())

/**
 * This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical.
 *
 * If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
 */
public suspend inline fun Route53DomainsClient.updateDomainContact(crossinline block: UpdateDomainContactRequest.Builder.() -> Unit): UpdateDomainContactResponse = updateDomainContact(UpdateDomainContactRequest.Builder().apply(block).build())

/**
 * This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org domains) or with contact information for our registrar associate, Gandi.
 *
 * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
 *
 * This operation affects only the contact information for the specified contact type (administrative, registrant, or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.
 *
 * By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection using either `UpdateDomainContactPrivacy` or the Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database. For more information on our privacy practices, see [https://aws.amazon.com/privacy/](https://aws.amazon.com/privacy/).
 */
public suspend inline fun Route53DomainsClient.updateDomainContactPrivacy(crossinline block: UpdateDomainContactPrivacyRequest.Builder.() -> Unit): UpdateDomainContactPrivacyResponse = updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest.Builder().apply(block).build())

/**
 * This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
 *
 * If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
 */
public suspend inline fun Route53DomainsClient.updateDomainNameservers(crossinline block: UpdateDomainNameserversRequest.Builder.() -> Unit): UpdateDomainNameserversResponse = updateDomainNameservers(UpdateDomainNameserversRequest.Builder().apply(block).build())

/**
 * This operation adds or updates tags for a specified domain.
 *
 * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
 */
public suspend inline fun Route53DomainsClient.updateTagsForDomain(crossinline block: UpdateTagsForDomainRequest.Builder.() -> Unit): UpdateTagsForDomainResponse = updateTagsForDomain(UpdateTagsForDomainRequest.Builder().apply(block).build())

/**
 * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
 */
public suspend inline fun Route53DomainsClient.viewBilling(crossinline block: ViewBillingRequest.Builder.() -> Unit): ViewBillingResponse = viewBilling(ViewBillingRequest.Builder().apply(block).build())
