// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information for one billing record.
 */
public class BillingRecord private constructor(builder: Builder) {
    /**
     * The date that the operation was billed, in Unix format.
     */
    public val billDate: aws.smithy.kotlin.runtime.time.Instant? = builder.billDate
    /**
     * The name of the domain that the billing record applies to. If the domain name contains characters other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more information, see [DNS Domain Name Format](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html) in the *Amazon Route 53 Developer Guide*.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The ID of the invoice that is associated with the billing record.
     */
    public val invoiceId: kotlin.String? = builder.invoiceId
    /**
     * The operation that you were charged for.
     */
    public val operation: aws.sdk.kotlin.services.route53domains.model.OperationType? = builder.operation
    /**
     * The price that you were charged for the operation, in US dollars.
     *
     * Example value: 12.0
     */
    public val price: kotlin.Double = builder.price

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.BillingRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BillingRecord(")
        append("billDate=$billDate,")
        append("domainName=$domainName,")
        append("invoiceId=$invoiceId,")
        append("operation=$operation,")
        append("price=$price)")
    }

    override fun hashCode(): kotlin.Int {
        var result = billDate?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (invoiceId?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (price.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BillingRecord

        if (billDate != other.billDate) return false
        if (domainName != other.domainName) return false
        if (invoiceId != other.invoiceId) return false
        if (operation != other.operation) return false
        if (price != other.price) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.BillingRecord = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date that the operation was billed, in Unix format.
         */
        public var billDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the domain that the billing record applies to. If the domain name contains characters other than a-z, 0-9, and - (hyphen), such as an internationalized domain name, then this value is in Punycode. For more information, see [DNS Domain Name Format](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html) in the *Amazon Route 53 Developer Guide*.
         */
        public var domainName: kotlin.String? = null
        /**
         * The ID of the invoice that is associated with the billing record.
         */
        public var invoiceId: kotlin.String? = null
        /**
         * The operation that you were charged for.
         */
        public var operation: aws.sdk.kotlin.services.route53domains.model.OperationType? = null
        /**
         * The price that you were charged for the operation, in US dollars.
         *
         * Example value: 12.0
         */
        public var price: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.BillingRecord) : this() {
            this.billDate = x.billDate
            this.domainName = x.domainName
            this.invoiceId = x.invoiceId
            this.operation = x.operation
            this.price = x.price
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.BillingRecord = BillingRecord(this)
    }
}
