// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The GetDomainDetail response includes the following elements.
 */
public class GetDomainDetailResponse private constructor(builder: Builder) {
    /**
     * Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
     */
    public val abuseContactEmail: kotlin.String? = builder.abuseContactEmail
    /**
     * Phone number for reporting abuse.
     */
    public val abuseContactPhone: kotlin.String? = builder.abuseContactPhone
    /**
     * Provides details about the domain administrative contact.
     */
    public val adminContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.adminContact
    /**
     * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the admin contact.
     */
    public val adminPrivacy: kotlin.Boolean? = builder.adminPrivacy
    /**
     * Specifies whether the domain registration is set to renew automatically.
     */
    public val autoRenew: kotlin.Boolean? = builder.autoRenew
    /**
     * The date when the domain was created as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * Deprecated.
     */
    public val dnsSec: kotlin.String? = builder.dnsSec
    /**
     * The name of a domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The date when the registration for the domain is set to expire. The date and time is in Unix time format and Coordinated Universal time (UTC).
     */
    public val expirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationDate
    /**
     * The name of the domain.
     */
    public val nameservers: List<Nameserver>? = builder.nameservers
    /**
     * Provides details about the domain registrant.
     */
    public val registrantContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.registrantContact
    /**
     * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the registrant contact (domain owner).
     */
    public val registrantPrivacy: kotlin.Boolean? = builder.registrantPrivacy
    /**
     * Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by Gandi is `"GANDI SAS"`.
     */
    public val registrarName: kotlin.String? = builder.registrarName
    /**
     * Web address of the registrar.
     */
    public val registrarUrl: kotlin.String? = builder.registrarUrl
    /**
     * Reserved for future use.
     */
    public val registryDomainId: kotlin.String? = builder.registryDomainId
    /**
     * Reseller of the domain. Domains registered or transferred using Route 53 domains will have `"Amazon"` as the reseller.
     */
    public val reseller: kotlin.String? = builder.reseller
    /**
     * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
     *
     * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars use this same set of status codes.
     *
     * For a current list of domain name status codes and an explanation of what each code means, go to the [ICANN website](https://www.icann.org/) and search for `epp status codes`. (Search on the ICANN website; web searches sometimes return an old version of the document.)
     */
    public val statusList: List<String>? = builder.statusList
    /**
     * Provides details about the domain technical contact.
     */
    public val techContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.techContact
    /**
     * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the technical contact.
     */
    public val techPrivacy: kotlin.Boolean? = builder.techPrivacy
    /**
     * The last updated date of the domain as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).
     */
    public val updatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedDate
    /**
     * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
     */
    public val whoIsServer: kotlin.String? = builder.whoIsServer

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDomainDetailResponse(")
        append("abuseContactEmail=$abuseContactEmail,")
        append("abuseContactPhone=$abuseContactPhone,")
        append("adminContact=*** Sensitive Data Redacted ***,")
        append("adminPrivacy=$adminPrivacy,")
        append("autoRenew=$autoRenew,")
        append("creationDate=$creationDate,")
        append("dnsSec=$dnsSec,")
        append("domainName=$domainName,")
        append("expirationDate=$expirationDate,")
        append("nameservers=$nameservers,")
        append("registrantContact=*** Sensitive Data Redacted ***,")
        append("registrantPrivacy=$registrantPrivacy,")
        append("registrarName=$registrarName,")
        append("registrarUrl=$registrarUrl,")
        append("registryDomainId=$registryDomainId,")
        append("reseller=$reseller,")
        append("statusList=$statusList,")
        append("techContact=*** Sensitive Data Redacted ***,")
        append("techPrivacy=$techPrivacy,")
        append("updatedDate=$updatedDate,")
        append("whoIsServer=$whoIsServer)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abuseContactEmail?.hashCode() ?: 0
        result = 31 * result + (abuseContactPhone?.hashCode() ?: 0)
        result = 31 * result + (adminContact?.hashCode() ?: 0)
        result = 31 * result + (adminPrivacy?.hashCode() ?: 0)
        result = 31 * result + (autoRenew?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (dnsSec?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (expirationDate?.hashCode() ?: 0)
        result = 31 * result + (nameservers?.hashCode() ?: 0)
        result = 31 * result + (registrantContact?.hashCode() ?: 0)
        result = 31 * result + (registrantPrivacy?.hashCode() ?: 0)
        result = 31 * result + (registrarName?.hashCode() ?: 0)
        result = 31 * result + (registrarUrl?.hashCode() ?: 0)
        result = 31 * result + (registryDomainId?.hashCode() ?: 0)
        result = 31 * result + (reseller?.hashCode() ?: 0)
        result = 31 * result + (statusList?.hashCode() ?: 0)
        result = 31 * result + (techContact?.hashCode() ?: 0)
        result = 31 * result + (techPrivacy?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        result = 31 * result + (whoIsServer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDomainDetailResponse

        if (abuseContactEmail != other.abuseContactEmail) return false
        if (abuseContactPhone != other.abuseContactPhone) return false
        if (adminContact != other.adminContact) return false
        if (adminPrivacy != other.adminPrivacy) return false
        if (autoRenew != other.autoRenew) return false
        if (creationDate != other.creationDate) return false
        if (dnsSec != other.dnsSec) return false
        if (domainName != other.domainName) return false
        if (expirationDate != other.expirationDate) return false
        if (nameservers != other.nameservers) return false
        if (registrantContact != other.registrantContact) return false
        if (registrantPrivacy != other.registrantPrivacy) return false
        if (registrarName != other.registrarName) return false
        if (registrarUrl != other.registrarUrl) return false
        if (registryDomainId != other.registryDomainId) return false
        if (reseller != other.reseller) return false
        if (statusList != other.statusList) return false
        if (techContact != other.techContact) return false
        if (techPrivacy != other.techPrivacy) return false
        if (updatedDate != other.updatedDate) return false
        if (whoIsServer != other.whoIsServer) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Email address to contact to report incorrect contact information for a domain, to report that the domain is being used to send spam, to report that someone is cybersquatting on a domain name, or report some other type of abuse.
         */
        public var abuseContactEmail: kotlin.String? = null
        /**
         * Phone number for reporting abuse.
         */
        public var abuseContactPhone: kotlin.String? = null
        /**
         * Provides details about the domain administrative contact.
         */
        public var adminContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null
        /**
         * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the admin contact.
         */
        public var adminPrivacy: kotlin.Boolean? = null
        /**
         * Specifies whether the domain registration is set to renew automatically.
         */
        public var autoRenew: kotlin.Boolean? = null
        /**
         * The date when the domain was created as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Deprecated.
         */
        public var dnsSec: kotlin.String? = null
        /**
         * The name of a domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The date when the registration for the domain is set to expire. The date and time is in Unix time format and Coordinated Universal time (UTC).
         */
        public var expirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the domain.
         */
        public var nameservers: List<Nameserver>? = null
        /**
         * Provides details about the domain registrant.
         */
        public var registrantContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null
        /**
         * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the registrant contact (domain owner).
         */
        public var registrantPrivacy: kotlin.Boolean? = null
        /**
         * Name of the registrar of the domain as identified in the registry. Domains with a .com, .net, or .org TLD are registered by Amazon Registrar. All other domains are registered by our registrar associate, Gandi. The value for domains that are registered by Gandi is `"GANDI SAS"`.
         */
        public var registrarName: kotlin.String? = null
        /**
         * Web address of the registrar.
         */
        public var registrarUrl: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var registryDomainId: kotlin.String? = null
        /**
         * Reseller of the domain. Domains registered or transferred using Route 53 domains will have `"Amazon"` as the reseller.
         */
        public var reseller: kotlin.String? = null
        /**
         * An array of domain name status codes, also known as Extensible Provisioning Protocol (EPP) status codes.
         *
         * ICANN, the organization that maintains a central database of domain names, has developed a set of domain name status codes that tell you the status of a variety of operations on a domain name, for example, registering a domain name, transferring a domain name to another registrar, renewing the registration for a domain name, and so on. All registrars use this same set of status codes.
         *
         * For a current list of domain name status codes and an explanation of what each code means, go to the [ICANN website](https://www.icann.org/) and search for `epp status codes`. (Search on the ICANN website; web searches sometimes return an old version of the document.)
         */
        public var statusList: List<String>? = null
        /**
         * Provides details about the domain technical contact.
         */
        public var techContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null
        /**
         * Specifies whether contact information is concealed from WHOIS queries. If the value is `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If the value is `false`, WHOIS queries return the information that you entered for the technical contact.
         */
        public var techPrivacy: kotlin.Boolean? = null
        /**
         * The last updated date of the domain as found in the response to a WHOIS query. The date and time is in Unix time format and Coordinated Universal time (UTC).
         */
        public var updatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The fully qualified name of the WHOIS server that can answer the WHOIS query for the domain.
         */
        public var whoIsServer: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse) : this() {
            this.abuseContactEmail = x.abuseContactEmail
            this.abuseContactPhone = x.abuseContactPhone
            this.adminContact = x.adminContact
            this.adminPrivacy = x.adminPrivacy
            this.autoRenew = x.autoRenew
            this.creationDate = x.creationDate
            this.dnsSec = x.dnsSec
            this.domainName = x.domainName
            this.expirationDate = x.expirationDate
            this.nameservers = x.nameservers
            this.registrantContact = x.registrantContact
            this.registrantPrivacy = x.registrantPrivacy
            this.registrarName = x.registrarName
            this.registrarUrl = x.registrarUrl
            this.registryDomainId = x.registryDomainId
            this.reseller = x.reseller
            this.statusList = x.statusList
            this.techContact = x.techContact
            this.techPrivacy = x.techPrivacy
            this.updatedDate = x.updatedDate
            this.whoIsServer = x.whoIsServer
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse = GetDomainDetailResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun adminContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.adminContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun registrantContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.registrantContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun techContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.techContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }
    }
}
