// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The ListOperations request includes the following elements.
 */
public class ListOperationsRequest private constructor(builder: Builder) {
    /**
     * For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional operations. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Number of domains to be returned.
     *
     * Default: 20
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).
     */
    public val submittedSince: aws.smithy.kotlin.runtime.time.Instant? = builder.submittedSince

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListOperationsRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("submittedSince=$submittedSince)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (submittedSince?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListOperationsRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (submittedSince != other.submittedSince) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional operations. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
         */
        public var marker: kotlin.String? = null
        /**
         * Number of domains to be returned.
         *
         * Default: 20
         */
        public var maxItems: kotlin.Int? = null
        /**
         * An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).
         */
        public var submittedSince: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.submittedSince = x.submittedSince
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest = ListOperationsRequest(this)
    }
}
