// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * A `RenewDomain` request includes the number of years that you want to renew for and the current expiration year.
 */
public class RenewDomainRequest private constructor(builder: Builder) {
    /**
     * The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.
     */
    public val currentExpiryYear: kotlin.Int = builder.currentExpiryYear
    /**
     * The name of the domain that you want to renew.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
     *
     * Default: 1
     */
    public val durationInYears: kotlin.Int? = builder.durationInYears

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.RenewDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenewDomainRequest(")
        append("currentExpiryYear=$currentExpiryYear,")
        append("domainName=$domainName,")
        append("durationInYears=$durationInYears)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentExpiryYear
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (durationInYears ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenewDomainRequest

        if (currentExpiryYear != other.currentExpiryYear) return false
        if (domainName != other.domainName) return false
        if (durationInYears != other.durationInYears) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.RenewDomainRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.
         */
        public var currentExpiryYear: kotlin.Int = 0
        /**
         * The name of the domain that you want to renew.
         */
        public var domainName: kotlin.String? = null
        /**
         * The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
         *
         * Default: 1
         */
        public var durationInYears: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.RenewDomainRequest) : this() {
            this.currentExpiryYear = x.currentExpiryYear
            this.domainName = x.domainName
            this.durationInYears = x.durationInYears
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.RenewDomainRequest = RenewDomainRequest(this)
    }
}
