// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * The TransferDomain request includes the following elements.
 */
public class TransferDomainRequest private constructor(builder: Builder) {
    /**
     * Provides detailed contact information.
     */
    public val adminContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.adminContact
    /**
     * The authorization code for the domain. You get this value from the current registrar.
     */
    public val authCode: kotlin.String? = builder.authCode
    /**
     * Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.
     *
     * Default: true
     */
    public val autoRenew: kotlin.Boolean? = builder.autoRenew
    /**
     * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
     *
     * The domain name can contain only the following characters:
     * + Letters a through z. Domain names are not case sensitive.
     * + Numbers 0 through 9.
     * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.
     *
     * Default: 1
     */
    public val durationInYears: kotlin.Int? = builder.durationInYears
    /**
     * Reserved for future use.
     */
    public val idnLangCode: kotlin.String? = builder.idnLangCode
    /**
     * Contains details for the host and glue IP addresses.
     */
    public val nameservers: List<Nameserver>? = builder.nameservers
    /**
     * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the admin contact.
     *
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *
     * Default: `true`
     */
    public val privacyProtectAdminContact: kotlin.Boolean? = builder.privacyProtectAdminContact
    /**
     * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the registrant contact (domain owner).
     *
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *
     * Default: `true`
     */
    public val privacyProtectRegistrantContact: kotlin.Boolean? = builder.privacyProtectRegistrantContact
    /**
     * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the technical contact.
     *
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *
     * Default: `true`
     */
    public val privacyProtectTechContact: kotlin.Boolean? = builder.privacyProtectTechContact
    /**
     * Provides detailed contact information.
     */
    public val registrantContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.registrantContact
    /**
     * Provides detailed contact information.
     */
    public val techContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = builder.techContact

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransferDomainRequest(")
        append("adminContact=*** Sensitive Data Redacted ***,")
        append("authCode=*** Sensitive Data Redacted ***,")
        append("autoRenew=$autoRenew,")
        append("domainName=$domainName,")
        append("durationInYears=$durationInYears,")
        append("idnLangCode=$idnLangCode,")
        append("nameservers=$nameservers,")
        append("privacyProtectAdminContact=$privacyProtectAdminContact,")
        append("privacyProtectRegistrantContact=$privacyProtectRegistrantContact,")
        append("privacyProtectTechContact=$privacyProtectTechContact,")
        append("registrantContact=*** Sensitive Data Redacted ***,")
        append("techContact=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminContact?.hashCode() ?: 0
        result = 31 * result + (authCode?.hashCode() ?: 0)
        result = 31 * result + (autoRenew?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (durationInYears ?: 0)
        result = 31 * result + (idnLangCode?.hashCode() ?: 0)
        result = 31 * result + (nameservers?.hashCode() ?: 0)
        result = 31 * result + (privacyProtectAdminContact?.hashCode() ?: 0)
        result = 31 * result + (privacyProtectRegistrantContact?.hashCode() ?: 0)
        result = 31 * result + (privacyProtectTechContact?.hashCode() ?: 0)
        result = 31 * result + (registrantContact?.hashCode() ?: 0)
        result = 31 * result + (techContact?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransferDomainRequest

        if (adminContact != other.adminContact) return false
        if (authCode != other.authCode) return false
        if (autoRenew != other.autoRenew) return false
        if (domainName != other.domainName) return false
        if (durationInYears != other.durationInYears) return false
        if (idnLangCode != other.idnLangCode) return false
        if (nameservers != other.nameservers) return false
        if (privacyProtectAdminContact != other.privacyProtectAdminContact) return false
        if (privacyProtectRegistrantContact != other.privacyProtectRegistrantContact) return false
        if (privacyProtectTechContact != other.privacyProtectTechContact) return false
        if (registrantContact != other.registrantContact) return false
        if (techContact != other.techContact) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides detailed contact information.
         */
        public var adminContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null
        /**
         * The authorization code for the domain. You get this value from the current registrar.
         */
        public var authCode: kotlin.String? = null
        /**
         * Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged.
         *
         * Default: true
         */
        public var autoRenew: kotlin.Boolean? = null
        /**
         * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
         *
         * The domain name can contain only the following characters:
         * + Letters a through z. Domain names are not case sensitive.
         * + Numbers 0 through 9.
         * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
         */
        public var domainName: kotlin.String? = null
        /**
         * The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain.
         *
         * Default: 1
         */
        public var durationInYears: kotlin.Int? = null
        /**
         * Reserved for future use.
         */
        public var idnLangCode: kotlin.String? = null
        /**
         * Contains details for the host and glue IP addresses.
         */
        public var nameservers: List<Nameserver>? = null
        /**
         * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the admin contact.
         *
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *
         * Default: `true`
         */
        public var privacyProtectAdminContact: kotlin.Boolean? = null
        /**
         * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the registrant contact (domain owner).
         *
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *
         * Default: `true`
         */
        public var privacyProtectRegistrantContact: kotlin.Boolean? = null
        /**
         * Whether you want to conceal contact information from WHOIS queries. If you specify `true`, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify `false`, WHOIS queries return the information that you entered for the technical contact.
         *
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *
         * Default: `true`
         */
        public var privacyProtectTechContact: kotlin.Boolean? = null
        /**
         * Provides detailed contact information.
         */
        public var registrantContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null
        /**
         * Provides detailed contact information.
         */
        public var techContact: aws.sdk.kotlin.services.route53domains.model.ContactDetail? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest) : this() {
            this.adminContact = x.adminContact
            this.authCode = x.authCode
            this.autoRenew = x.autoRenew
            this.domainName = x.domainName
            this.durationInYears = x.durationInYears
            this.idnLangCode = x.idnLangCode
            this.nameservers = x.nameservers
            this.privacyProtectAdminContact = x.privacyProtectAdminContact
            this.privacyProtectRegistrantContact = x.privacyProtectRegistrantContact
            this.privacyProtectTechContact = x.privacyProtectTechContact
            this.registrantContact = x.registrantContact
            this.techContact = x.techContact
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest = TransferDomainRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun adminContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.adminContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun registrantContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.registrantContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.ContactDetail] inside the given [block]
         */
        public fun techContact(block: aws.sdk.kotlin.services.route53domains.model.ContactDetail.Builder.() -> kotlin.Unit) {
            this.techContact = aws.sdk.kotlin.services.route53domains.model.ContactDetail.invoke(block)
        }
    }
}
