// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * Replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
 *
 * If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
 */
public class UpdateDomainNameserversRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that you want to change name servers for.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The authorization key for .fi domains
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val fiAuthKey: kotlin.String? = builder.fiAuthKey
    /**
     * A list of new name servers for the domain.
     */
    public val nameservers: List<Nameserver>? = builder.nameservers

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainNameserversRequest(")
        append("domainName=$domainName,")
        append("fiAuthKey=*** Sensitive Data Redacted ***,")
        append("nameservers=$nameservers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (fiAuthKey?.hashCode() ?: 0)
        result = 31 * result + (nameservers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainNameserversRequest

        if (domainName != other.domainName) return false
        if (fiAuthKey != other.fiAuthKey) return false
        if (nameservers != other.nameservers) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that you want to change name servers for.
         */
        public var domainName: kotlin.String? = null
        /**
         * The authorization key for .fi domains
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var fiAuthKey: kotlin.String? = null
        /**
         * A list of new name servers for the domain.
         */
        public var nameservers: List<Nameserver>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversRequest) : this() {
            this.domainName = x.domainName
            this.fiAuthKey = x.fiAuthKey
            this.nameservers = x.nameservers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.UpdateDomainNameserversRequest = UpdateDomainNameserversRequest(this)
    }
}
