// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.ContactDetail
import aws.sdk.kotlin.services.route53domains.model.GetDomainDetailResponse
import aws.sdk.kotlin.services.route53domains.model.Nameserver
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDomainDetailOperationDeserializer: HttpDeserialize<GetDomainDetailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDomainDetailResponse {
        if (!response.status.isSuccess()) {
            throwGetDomainDetailError(context, response)
        }
        val builder = GetDomainDetailResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDomainDetailOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDomainDetailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedTLD" -> UnsupportedTldDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDomainDetailOperationBody(builder: GetDomainDetailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ABUSECONTACTEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AbuseContactEmail"))
    val ABUSECONTACTPHONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AbuseContactPhone"))
    val ADMINCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AdminContact"))
    val ADMINPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AdminPrivacy"))
    val AUTORENEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoRenew"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val DNSSEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DnsSec"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val EXPIRATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpirationDate"))
    val NAMESERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Nameservers"))
    val REGISTRANTCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RegistrantContact"))
    val REGISTRANTPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("RegistrantPrivacy"))
    val REGISTRARNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegistrarName"))
    val REGISTRARURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegistrarUrl"))
    val REGISTRYDOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RegistryDomainId"))
    val RESELLER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Reseller"))
    val STATUSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("StatusList"))
    val TECHCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TechContact"))
    val TECHPRIVACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("TechPrivacy"))
    val UPDATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedDate"))
    val WHOISSERVER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WhoIsServer"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABUSECONTACTEMAIL_DESCRIPTOR)
        field(ABUSECONTACTPHONE_DESCRIPTOR)
        field(ADMINCONTACT_DESCRIPTOR)
        field(ADMINPRIVACY_DESCRIPTOR)
        field(AUTORENEW_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(DNSSEC_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(EXPIRATIONDATE_DESCRIPTOR)
        field(NAMESERVERS_DESCRIPTOR)
        field(REGISTRANTCONTACT_DESCRIPTOR)
        field(REGISTRANTPRIVACY_DESCRIPTOR)
        field(REGISTRARNAME_DESCRIPTOR)
        field(REGISTRARURL_DESCRIPTOR)
        field(REGISTRYDOMAINID_DESCRIPTOR)
        field(RESELLER_DESCRIPTOR)
        field(STATUSLIST_DESCRIPTOR)
        field(TECHCONTACT_DESCRIPTOR)
        field(TECHPRIVACY_DESCRIPTOR)
        field(UPDATEDDATE_DESCRIPTOR)
        field(WHOISSERVER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ABUSECONTACTEMAIL_DESCRIPTOR.index -> builder.abuseContactEmail = deserializeString()
                ABUSECONTACTPHONE_DESCRIPTOR.index -> builder.abuseContactPhone = deserializeString()
                ADMINCONTACT_DESCRIPTOR.index -> builder.adminContact = deserializeContactDetailDocument(deserializer)
                ADMINPRIVACY_DESCRIPTOR.index -> builder.adminPrivacy = deserializeBoolean()
                AUTORENEW_DESCRIPTOR.index -> builder.autoRenew = deserializeBoolean()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DNSSEC_DESCRIPTOR.index -> builder.dnsSec = deserializeString()
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                EXPIRATIONDATE_DESCRIPTOR.index -> builder.expirationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAMESERVERS_DESCRIPTOR.index -> builder.nameservers =
                    deserializer.deserializeList(NAMESERVERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Nameserver>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNameserverDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REGISTRANTCONTACT_DESCRIPTOR.index -> builder.registrantContact = deserializeContactDetailDocument(deserializer)
                REGISTRANTPRIVACY_DESCRIPTOR.index -> builder.registrantPrivacy = deserializeBoolean()
                REGISTRARNAME_DESCRIPTOR.index -> builder.registrarName = deserializeString()
                REGISTRARURL_DESCRIPTOR.index -> builder.registrarUrl = deserializeString()
                REGISTRYDOMAINID_DESCRIPTOR.index -> builder.registryDomainId = deserializeString()
                RESELLER_DESCRIPTOR.index -> builder.reseller = deserializeString()
                STATUSLIST_DESCRIPTOR.index -> builder.statusList =
                    deserializer.deserializeList(STATUSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TECHCONTACT_DESCRIPTOR.index -> builder.techContact = deserializeContactDetailDocument(deserializer)
                TECHPRIVACY_DESCRIPTOR.index -> builder.techPrivacy = deserializeBoolean()
                UPDATEDDATE_DESCRIPTOR.index -> builder.updatedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                WHOISSERVER_DESCRIPTOR.index -> builder.whoIsServer = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
