// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.GetOperationDetailResponse
import aws.sdk.kotlin.services.route53domains.model.OperationStatus
import aws.sdk.kotlin.services.route53domains.model.OperationType
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetOperationDetailOperationDeserializer: HttpDeserialize<GetOperationDetailResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetOperationDetailResponse {
        if (!response.status.isSuccess()) {
            throwGetOperationDetailError(context, response)
        }
        val builder = GetOperationDetailResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOperationDetailOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetOperationDetailError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOperationDetailOperationBody(builder: GetOperationDetailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperationId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val SUBMITTEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SubmittedDate"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINNAME_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(OPERATIONID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUBMITTEDDATE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINNAME_DESCRIPTOR.index -> builder.domainName = deserializeString()
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                OPERATIONID_DESCRIPTOR.index -> builder.operationId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { OperationStatus.fromValue(it) }
                SUBMITTEDDATE_DESCRIPTOR.index -> builder.submittedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { OperationType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
