// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.services.route53domains.model.ContactDetail
import aws.sdk.kotlin.services.route53domains.model.Nameserver
import aws.sdk.kotlin.services.route53domains.model.TransferDomainRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TransferDomainOperationSerializer: HttpSerialize<TransferDomainRequest> {
    override suspend fun serialize(context: ExecutionContext, input: TransferDomainRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeTransferDomainOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeTransferDomainOperationBody(context: ExecutionContext, input: TransferDomainRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADMINCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AdminContact"))
    val AUTHCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthCode"))
    val AUTORENEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AutoRenew"))
    val DOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DomainName"))
    val DURATIONINYEARS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("DurationInYears"))
    val IDNLANGCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdnLangCode"))
    val NAMESERVERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Nameservers"))
    val PRIVACYPROTECTADMINCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PrivacyProtectAdminContact"))
    val PRIVACYPROTECTREGISTRANTCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PrivacyProtectRegistrantContact"))
    val PRIVACYPROTECTTECHCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PrivacyProtectTechContact"))
    val REGISTRANTCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RegistrantContact"))
    val TECHCONTACT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TechContact"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADMINCONTACT_DESCRIPTOR)
        field(AUTHCODE_DESCRIPTOR)
        field(AUTORENEW_DESCRIPTOR)
        field(DOMAINNAME_DESCRIPTOR)
        field(DURATIONINYEARS_DESCRIPTOR)
        field(IDNLANGCODE_DESCRIPTOR)
        field(NAMESERVERS_DESCRIPTOR)
        field(PRIVACYPROTECTADMINCONTACT_DESCRIPTOR)
        field(PRIVACYPROTECTREGISTRANTCONTACT_DESCRIPTOR)
        field(PRIVACYPROTECTTECHCONTACT_DESCRIPTOR)
        field(REGISTRANTCONTACT_DESCRIPTOR)
        field(TECHCONTACT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.adminContact?.let { field(ADMINCONTACT_DESCRIPTOR, it, ::serializeContactDetailDocument) }
        input.authCode?.let { field(AUTHCODE_DESCRIPTOR, it) }
        input.autoRenew?.let { field(AUTORENEW_DESCRIPTOR, it) }
        input.domainName?.let { field(DOMAINNAME_DESCRIPTOR, it) }
        input.durationInYears?.let { field(DURATIONINYEARS_DESCRIPTOR, it) }
        input.idnLangCode?.let { field(IDNLANGCODE_DESCRIPTOR, it) }
        if (input.nameservers != null) {
            listField(NAMESERVERS_DESCRIPTOR) {
                for (el0 in input.nameservers) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeNameserverDocument))
                }
            }
        }
        input.privacyProtectAdminContact?.let { field(PRIVACYPROTECTADMINCONTACT_DESCRIPTOR, it) }
        input.privacyProtectRegistrantContact?.let { field(PRIVACYPROTECTREGISTRANTCONTACT_DESCRIPTOR, it) }
        input.privacyProtectTechContact?.let { field(PRIVACYPROTECTTECHCONTACT_DESCRIPTOR, it) }
        input.registrantContact?.let { field(REGISTRANTCONTACT_DESCRIPTOR, it, ::serializeContactDetailDocument) }
        input.techContact?.let { field(TECHCONTACT_DESCRIPTOR, it, ::serializeContactDetailDocument) }
    }
    return serializer.toByteArray()
}
