// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.route53domains.model.*
import aws.sdk.kotlin.services.route53domains.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Route 53 Domains"
public const val ServiceApiVersion: String = "2014-05-15"
public const val SdkVersion: String = "0.17.8-beta"

internal class DefaultRoute53DomainsClient(override val config: Route53DomainsClient.Config) : Route53DomainsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts the transfer of a domain from another Amazon Web Services account to the currentAmazon Web Services account. You initiate a transfer between Amazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * If you use the CLI command at [accept-domain-transfer-from-another-aws-account](https://docs.aws.amazon.com/cli/latest/reference/route53domains/accept-domain-transfer-from-another-aws-account.html), use JSON format as input instead of text because otherwise CLI will throw an error from domain transfer input that includes single quotes.
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    override suspend fun acceptDomainTransferFromAnotherAwsAccount(input: AcceptDomainTransferFromAnotherAwsAccountRequest): AcceptDomainTransferFromAnotherAwsAccountResponse {
        val op = SdkHttpOperation.build<AcceptDomainTransferFromAnotherAwsAccountRequest, AcceptDomainTransferFromAnotherAwsAccountResponse> {
            serializer = AcceptDomainTransferFromAnotherAwsAccountOperationSerializer()
            deserializer = AcceptDomainTransferFromAnotherAwsAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptDomainTransferFromAnotherAwsAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the transfer of a domain from the current Amazon Web Services account to another Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * You must cancel the transfer before the other Amazon Web Services account accepts the transfer using [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    override suspend fun cancelDomainTransferToAnotherAwsAccount(input: CancelDomainTransferToAnotherAwsAccountRequest): CancelDomainTransferToAnotherAwsAccountResponse {
        val op = SdkHttpOperation.build<CancelDomainTransferToAnotherAwsAccountRequest, CancelDomainTransferToAnotherAwsAccountResponse> {
            serializer = CancelDomainTransferToAnotherAwsAccountOperationSerializer()
            deserializer = CancelDomainTransferToAnotherAwsAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDomainTransferToAnotherAwsAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation checks the availability of one domain name. Note that if the availability status of a domain is pending, you must submit another request to determine the availability of the domain name.
     */
    override suspend fun checkDomainAvailability(input: CheckDomainAvailabilityRequest): CheckDomainAvailabilityResponse {
        val op = SdkHttpOperation.build<CheckDomainAvailabilityRequest, CheckDomainAvailabilityResponse> {
            serializer = CheckDomainAvailabilityOperationSerializer()
            deserializer = CheckDomainAvailabilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckDomainAvailability"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Checks whether a domain name can be transferred to Amazon Route 53.
     */
    override suspend fun checkDomainTransferability(input: CheckDomainTransferabilityRequest): CheckDomainTransferabilityResponse {
        val op = SdkHttpOperation.build<CheckDomainTransferabilityRequest, CheckDomainTransferabilityResponse> {
            serializer = CheckDomainTransferabilityOperationSerializer()
            deserializer = CheckDomainTransferabilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckDomainTransferability"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes the specified domain. This action is permanent. For more information, see [Deleting a domain name registration](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-delete.html).
     *
     * To transfer the domain registration to another registrar, use the transfer process that’s provided by the registrar to which you want to transfer the registration. Otherwise, the following apply:
     * + You can’t get a refund for the cost of a deleted domain registration.
     * + The registry for the top-level domain might hold the domain name for a brief time before releasing it for other users to register (varies by registry).
     * + When the registration has been deleted, we'll send you a confirmation to the registrant contact. The email will come from `noreply@domainnameverification.net` or `noreply@registrar.amazon.com`.
     */
    override suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse {
        val op = SdkHttpOperation.build<DeleteDomainRequest, DeleteDomainResponse> {
            serializer = DeleteDomainOperationSerializer()
            deserializer = DeleteDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation deletes the specified tags for a domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    override suspend fun deleteTagsForDomain(input: DeleteTagsForDomainRequest): DeleteTagsForDomainResponse {
        val op = SdkHttpOperation.build<DeleteTagsForDomainRequest, DeleteTagsForDomainResponse> {
            serializer = DeleteTagsForDomainOperationSerializer()
            deserializer = DeleteTagsForDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTagsForDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation disables automatic renewal of domain registration for the specified domain.
     */
    override suspend fun disableDomainAutoRenew(input: DisableDomainAutoRenewRequest): DisableDomainAutoRenewResponse {
        val op = SdkHttpOperation.build<DisableDomainAutoRenewRequest, DisableDomainAutoRenewResponse> {
            serializer = DisableDomainAutoRenewOperationSerializer()
            deserializer = DisableDomainAutoRenewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableDomainAutoRenew"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation removes the transfer lock on the domain (specifically the `clientTransferProhibited` status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    override suspend fun disableDomainTransferLock(input: DisableDomainTransferLockRequest): DisableDomainTransferLockResponse {
        val op = SdkHttpOperation.build<DisableDomainTransferLockRequest, DisableDomainTransferLockResponse> {
            serializer = DisableDomainTransferLockOperationSerializer()
            deserializer = DisableDomainTransferLockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableDomainTransferLock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your Amazon Web Services account.
     *
     * The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see [Domains That You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*. Route 53 requires that you renew before the end of the renewal period so we can complete processing before the deadline.
     */
    override suspend fun enableDomainAutoRenew(input: EnableDomainAutoRenewRequest): EnableDomainAutoRenewResponse {
        val op = SdkHttpOperation.build<EnableDomainAutoRenewRequest, EnableDomainAutoRenewResponse> {
            serializer = EnableDomainAutoRenewOperationSerializer()
            deserializer = EnableDomainAutoRenewOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableDomainAutoRenew"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation sets the transfer lock on the domain (specifically the `clientTransferProhibited` status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    override suspend fun enableDomainTransferLock(input: EnableDomainTransferLockRequest): EnableDomainTransferLockResponse {
        val op = SdkHttpOperation.build<EnableDomainTransferLockRequest, EnableDomainTransferLockResponse> {
            serializer = EnableDomainTransferLockOperationSerializer()
            deserializer = EnableDomainTransferLockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableDomainTransferLock"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded.
     *
     * If you want us to resend the email, use the `ResendContactReachabilityEmail` operation.
     */
    override suspend fun getContactReachabilityStatus(input: GetContactReachabilityStatusRequest): GetContactReachabilityStatusResponse {
        val op = SdkHttpOperation.build<GetContactReachabilityStatusRequest, GetContactReachabilityStatusResponse> {
            serializer = GetContactReachabilityStatusOperationSerializer()
            deserializer = GetContactReachabilityStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContactReachabilityStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns detailed information about a specified domain that is associated with the current Amazon Web Services account. Contact information for the domain is also returned as part of the output.
     */
    override suspend fun getDomainDetail(input: GetDomainDetailRequest): GetDomainDetailResponse {
        val op = SdkHttpOperation.build<GetDomainDetailRequest, GetDomainDetailResponse> {
            serializer = GetDomainDetailOperationSerializer()
            deserializer = GetDomainDetailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainDetail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The GetDomainSuggestions operation returns a list of suggested domain names.
     */
    override suspend fun getDomainSuggestions(input: GetDomainSuggestionsRequest): GetDomainSuggestionsResponse {
        val op = SdkHttpOperation.build<GetDomainSuggestionsRequest, GetDomainSuggestionsResponse> {
            serializer = GetDomainSuggestionsOperationSerializer()
            deserializer = GetDomainSuggestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainSuggestions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns the current status of an operation that is not completed.
     */
    override suspend fun getOperationDetail(input: GetOperationDetailRequest): GetOperationDetailResponse {
        val op = SdkHttpOperation.build<GetOperationDetailRequest, GetOperationDetailResponse> {
            serializer = GetOperationDetailOperationSerializer()
            deserializer = GetOperationDetailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOperationDetail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.
     */
    override suspend fun listDomains(input: ListDomainsRequest): ListDomainsResponse {
        val op = SdkHttpOperation.build<ListDomainsRequest, ListDomainsResponse> {
            serializer = ListDomainsOperationSerializer()
            deserializer = ListDomainsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomains"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account.
     *
     * This command runs only in the us-east-1 Region.
     */
    override suspend fun listOperations(input: ListOperationsRequest): ListOperationsResponse {
        val op = SdkHttpOperation.build<ListOperationsRequest, ListOperationsResponse> {
            serializer = ListOperationsOperationSerializer()
            deserializer = ListOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the following prices for either all the TLDs supported by Route 53, or the specified TLD:
     * + Registration
     * + Transfer
     * + Owner change
     * + Domain renewal
     * + Domain restoration
     */
    override suspend fun listPrices(input: ListPricesRequest): ListPricesResponse {
        val op = SdkHttpOperation.build<ListPricesRequest, ListPricesResponse> {
            serializer = ListPricesOperationSerializer()
            deserializer = ListPricesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPrices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns all of the tags that are associated with the specified domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    override suspend fun listTagsForDomain(input: ListTagsForDomainRequest): ListTagsForDomainResponse {
        val op = SdkHttpOperation.build<ListTagsForDomainRequest, ListTagsForDomainResponse> {
            serializer = ListTagsForDomainOperationSerializer()
            deserializer = ListTagsForDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters.
     *
     * When you register a domain, Amazon Route 53 does the following:
     * + Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.
     * + Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of the renewal date so you can choose whether to renew the registration.
     * + Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy protection, WHOIS queries return the information that you entered for the administrative, registrant, and technical contacts.You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     * + If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.
     * + Charges your Amazon Web Services account an amount based on the top-level domain. For more information, see [Amazon Route 53 Pricing](http://aws.amazon.com/route53/pricing/).
     */
    override suspend fun registerDomain(input: RegisterDomainRequest): RegisterDomainResponse {
        val op = SdkHttpOperation.build<RegisterDomainRequest, RegisterDomainResponse> {
            serializer = RegisterDomainOperationSerializer()
            deserializer = RegisterDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Rejects the transfer of a domain from another Amazon Web Services account to the current Amazon Web Services account. You initiate a transfer betweenAmazon Web Services accounts using [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    override suspend fun rejectDomainTransferFromAnotherAwsAccount(input: RejectDomainTransferFromAnotherAwsAccountRequest): RejectDomainTransferFromAnotherAwsAccountResponse {
        val op = SdkHttpOperation.build<RejectDomainTransferFromAnotherAwsAccountRequest, RejectDomainTransferFromAnotherAwsAccountResponse> {
            serializer = RejectDomainTransferFromAnotherAwsAccountOperationSerializer()
            deserializer = RejectDomainTransferFromAnotherAwsAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectDomainTransferFromAnotherAwsAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your Amazon Web Services account.
     *
     * We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see [Renewing Registration for a Domain](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html) in the *Amazon Route 53 Developer Guide*.
     */
    override suspend fun renewDomain(input: RenewDomainRequest): RenewDomainResponse {
        val op = SdkHttpOperation.build<RenewDomainRequest, RenewDomainResponse> {
            serializer = RenewDomainOperationSerializer()
            deserializer = RenewDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RenewDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.
     */
    override suspend fun resendContactReachabilityEmail(input: ResendContactReachabilityEmailRequest): ResendContactReachabilityEmailResponse {
        val op = SdkHttpOperation.build<ResendContactReachabilityEmailRequest, ResendContactReachabilityEmailResponse> {
            serializer = ResendContactReachabilityEmailOperationSerializer()
            deserializer = ResendContactReachabilityEmailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResendContactReachabilityEmail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.
     */
    override suspend fun retrieveDomainAuthCode(input: RetrieveDomainAuthCodeRequest): RetrieveDomainAuthCodeResponse {
        val op = SdkHttpOperation.build<RetrieveDomainAuthCodeRequest, RetrieveDomainAuthCodeResponse> {
            serializer = RetrieveDomainAuthCodeOperationSerializer()
            deserializer = RetrieveDomainAuthCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetrieveDomainAuthCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).
     *
     * For more information about transferring domains, see the following topics:
     * + For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring to Route 53, see [Transferring Registration for a Domain to Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html) in the *Amazon Route 53 Developer Guide*.
     * + For information about how to transfer a domain from one Amazon Web Services account to another, see [TransferDomainToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html).
     * + For information about how to transfer a domain to another domain registrar, see [Transferring a Domain from Amazon Route 53 to Another Registrar](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-from-route-53.html) in the *Amazon Route 53 Developer Guide*.
     *
     * If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.
     *
     * If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.
     *
     * If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.
     */
    override suspend fun transferDomain(input: TransferDomainRequest): TransferDomainResponse {
        val op = SdkHttpOperation.build<TransferDomainRequest, TransferDomainResponse> {
            serializer = TransferDomainOperationSerializer()
            deserializer = TransferDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TransferDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Transfers a domain from the current Amazon Web Services account to another Amazon Web Services account. Note the following:
     * + The Amazon Web Services account that you're transferring the domain to must accept the transfer. If the other account doesn't accept the transfer within 3 days, we cancel the transfer. See [AcceptDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html).
     * + You can cancel the transfer before the other account accepts it. See [CancelDomainTransferToAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html).
     * + The other account can reject the transfer. See [RejectDomainTransferFromAnotherAwsAccount](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html).
     *
     * When you transfer a domain from one Amazon Web Services account to another, Route 53 doesn't transfer the hosted zone that is associated with the domain. DNS resolution isn't affected if the domain and the hosted zone are owned by separate accounts, so transferring the hosted zone is optional. For information about transferring the hosted zone to another Amazon Web Services account, see [Migrating a Hosted Zone to a Different Amazon Web Services Account](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/hosted-zones-migrating.html) in the *Amazon Route 53 Developer Guide*.
     *
     * Use either [ListOperations](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html) or [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to determine whether the operation succeeded. [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) provides additional information, for example, `Domain Transfer from Aws Account 111122223333 has been cancelled`.
     */
    override suspend fun transferDomainToAnotherAwsAccount(input: TransferDomainToAnotherAwsAccountRequest): TransferDomainToAnotherAwsAccountResponse {
        val op = SdkHttpOperation.build<TransferDomainToAnotherAwsAccountRequest, TransferDomainToAnotherAwsAccountResponse> {
            serializer = TransferDomainToAnotherAwsAccountOperationSerializer()
            deserializer = TransferDomainToAnotherAwsAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TransferDomainToAnotherAwsAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical.
     *
     * If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    override suspend fun updateDomainContact(input: UpdateDomainContactRequest): UpdateDomainContactResponse {
        val op = SdkHttpOperation.build<UpdateDomainContactRequest, UpdateDomainContactResponse> {
            serializer = UpdateDomainContactOperationSerializer()
            deserializer = UpdateDomainContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org domains) or with contact information for our registrar associate, Gandi.
     *
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *
     * This operation affects only the contact information for the specified contact type (administrative, registrant, or technical). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with [GetOperationDetail](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html) to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.
     *
     * By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection using either `UpdateDomainContactPrivacy` or the Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database. For more information on our privacy practices, see [https://aws.amazon.com/privacy/](https://aws.amazon.com/privacy/).
     */
    override suspend fun updateDomainContactPrivacy(input: UpdateDomainContactPrivacyRequest): UpdateDomainContactPrivacyResponse {
        val op = SdkHttpOperation.build<UpdateDomainContactPrivacyRequest, UpdateDomainContactPrivacyResponse> {
            serializer = UpdateDomainContactPrivacyOperationSerializer()
            deserializer = UpdateDomainContactPrivacyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainContactPrivacy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
     *
     * If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.
     */
    override suspend fun updateDomainNameservers(input: UpdateDomainNameserversRequest): UpdateDomainNameserversResponse {
        val op = SdkHttpOperation.build<UpdateDomainNameserversRequest, UpdateDomainNameserversResponse> {
            serializer = UpdateDomainNameserversOperationSerializer()
            deserializer = UpdateDomainNameserversOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainNameservers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This operation adds or updates tags for a specified domain.
     *
     * All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.
     */
    override suspend fun updateTagsForDomain(input: UpdateTagsForDomainRequest): UpdateTagsForDomainResponse {
        val op = SdkHttpOperation.build<UpdateTagsForDomainRequest, UpdateTagsForDomainResponse> {
            serializer = UpdateTagsForDomainOperationSerializer()
            deserializer = UpdateTagsForDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTagsForDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all the domain-related billing records for the current Amazon Web Services account for a specified period
     */
    override suspend fun viewBilling(input: ViewBillingRequest): ViewBillingResponse {
        val op = SdkHttpOperation.build<ViewBillingRequest, ViewBillingResponse> {
            serializer = ViewBillingOperationSerializer()
            deserializer = ViewBillingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ViewBilling"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53Domains_v20140515", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "route53domains"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "route53domains")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
