// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * The CheckDomainAvailability request contains the following elements.
 */
public class CheckDomainAvailabilityRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
     *
     * The domain name can contain only the following characters:
     * + Letters a through z. Domain names are not case sensitive.
     * + Numbers 0 through 9.
     * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
     *
     * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html). For more information, see [Formatting Internationalized Domain Names](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns).
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Reserved for future use.
     */
    public val idnLangCode: kotlin.String? = builder.idnLangCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CheckDomainAvailabilityRequest(")
        append("domainName=$domainName,")
        append("idnLangCode=$idnLangCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (idnLangCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CheckDomainAvailabilityRequest

        if (domainName != other.domainName) return false
        if (idnLangCode != other.idnLangCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that you want to get availability for. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
         *
         * The domain name can contain only the following characters:
         * + Letters a through z. Domain names are not case sensitive.
         * + Numbers 0 through 9.
         * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
         *
         * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html). For more information, see [Formatting Internationalized Domain Names](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns).
         */
        public var domainName: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var idnLangCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityRequest) : this() {
            this.domainName = x.domainName
            this.idnLangCode = x.idnLangCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.CheckDomainAvailabilityRequest = CheckDomainAvailabilityRequest(this)
    }
}
