// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * The CheckDomainTransferability request contains the following elements.
 */
public class CheckDomainTransferabilityRequest private constructor(builder: Builder) {
    /**
     * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.
     */
    public val authCode: kotlin.String? = builder.authCode
    /**
     * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
     *
     * The domain name can contain only the following characters:
     * + Letters a through z. Domain names are not case sensitive.
     * + Numbers 0 through 9.
     * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
     */
    public val domainName: kotlin.String? = builder.domainName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CheckDomainTransferabilityRequest(")
        append("authCode=*** Sensitive Data Redacted ***,")
        append("domainName=$domainName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authCode?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CheckDomainTransferabilityRequest

        if (authCode != other.authCode) return false
        if (domainName != other.domainName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code that you got from the current registrar for the domain.
         */
        public var authCode: kotlin.String? = null
        /**
         * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
         *
         * The domain name can contain only the following characters:
         * + Letters a through z. Domain names are not case sensitive.
         * + Numbers 0 through 9.
         * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
         */
        public var domainName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityRequest) : this() {
            this.authCode = x.authCode
            this.domainName = x.domainName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.CheckDomainTransferabilityRequest = CheckDomainTransferabilityRequest(this)
    }
}
