// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * ContactDetail includes the following elements.
 */
public class ContactDetail private constructor(builder: Builder) {
    /**
     * First line of the contact's address.
     */
    public val addressLine1: kotlin.String? = builder.addressLine1
    /**
     * Second line of contact's address, if any.
     */
    public val addressLine2: kotlin.String? = builder.addressLine2
    /**
     * The city of the contact's address.
     */
    public val city: kotlin.String? = builder.city
    /**
     * Indicates whether the contact is a person, company, association, or public organization. Note the following:
     * + If you specify a value other than `PERSON`, you must also specify a value for `OrganizationName`.
     * + For some TLDs, the privacy protection available depends on the value that you specify for `Contact Type`. For the privacy protection settings for your TLD, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*
     * + For .es domains, the value of `ContactType` must be `PERSON` for all three contacts.
     */
    public val contactType: aws.sdk.kotlin.services.route53domains.model.ContactType? = builder.contactType
    /**
     * Code for the country of the contact's address.
     */
    public val countryCode: aws.sdk.kotlin.services.route53domains.model.CountryCode? = builder.countryCode
    /**
     * Email address of the contact.
     */
    public val email: kotlin.String? = builder.email
    /**
     * A list of name-value pairs for parameters required by certain top-level domains.
     */
    public val extraParams: List<ExtraParam>? = builder.extraParams
    /**
     * Fax number of the contact.
     *
     * Constraints: Phone number must be specified in the format "+&#91;country dialing code&#93;.&#91;number including any area code&#93;". For example, a US phone number might appear as `"+1.1234567890"`.
     */
    public val fax: kotlin.String? = builder.fax
    /**
     * First name of contact.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * Last name of contact.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * Name of the organization for contact types other than `PERSON`.
     */
    public val organizationName: kotlin.String? = builder.organizationName
    /**
     * The phone number of the contact.
     *
     * Constraints: Phone number must be specified in the format "+&#91;country dialing code&#93;.&#91;number including any area code>&#93;". For example, a US phone number might appear as `"+1.1234567890"`.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The state or province of the contact's city.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The zip or postal code of the contact's address.
     */
    public val zipCode: kotlin.String? = builder.zipCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.ContactDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactDetail(")
        append("addressLine1=$addressLine1,")
        append("addressLine2=$addressLine2,")
        append("city=$city,")
        append("contactType=$contactType,")
        append("countryCode=$countryCode,")
        append("email=$email,")
        append("extraParams=$extraParams,")
        append("fax=$fax,")
        append("firstName=$firstName,")
        append("lastName=$lastName,")
        append("organizationName=$organizationName,")
        append("phoneNumber=$phoneNumber,")
        append("state=$state,")
        append("zipCode=$zipCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressLine1?.hashCode() ?: 0
        result = 31 * result + (addressLine2?.hashCode() ?: 0)
        result = 31 * result + (city?.hashCode() ?: 0)
        result = 31 * result + (contactType?.hashCode() ?: 0)
        result = 31 * result + (countryCode?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (extraParams?.hashCode() ?: 0)
        result = 31 * result + (fax?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (organizationName?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (zipCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactDetail

        if (addressLine1 != other.addressLine1) return false
        if (addressLine2 != other.addressLine2) return false
        if (city != other.city) return false
        if (contactType != other.contactType) return false
        if (countryCode != other.countryCode) return false
        if (email != other.email) return false
        if (extraParams != other.extraParams) return false
        if (fax != other.fax) return false
        if (firstName != other.firstName) return false
        if (lastName != other.lastName) return false
        if (organizationName != other.organizationName) return false
        if (phoneNumber != other.phoneNumber) return false
        if (state != other.state) return false
        if (zipCode != other.zipCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.ContactDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * First line of the contact's address.
         */
        public var addressLine1: kotlin.String? = null
        /**
         * Second line of contact's address, if any.
         */
        public var addressLine2: kotlin.String? = null
        /**
         * The city of the contact's address.
         */
        public var city: kotlin.String? = null
        /**
         * Indicates whether the contact is a person, company, association, or public organization. Note the following:
         * + If you specify a value other than `PERSON`, you must also specify a value for `OrganizationName`.
         * + For some TLDs, the privacy protection available depends on the value that you specify for `Contact Type`. For the privacy protection settings for your TLD, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*
         * + For .es domains, the value of `ContactType` must be `PERSON` for all three contacts.
         */
        public var contactType: aws.sdk.kotlin.services.route53domains.model.ContactType? = null
        /**
         * Code for the country of the contact's address.
         */
        public var countryCode: aws.sdk.kotlin.services.route53domains.model.CountryCode? = null
        /**
         * Email address of the contact.
         */
        public var email: kotlin.String? = null
        /**
         * A list of name-value pairs for parameters required by certain top-level domains.
         */
        public var extraParams: List<ExtraParam>? = null
        /**
         * Fax number of the contact.
         *
         * Constraints: Phone number must be specified in the format "+&#91;country dialing code&#93;.&#91;number including any area code&#93;". For example, a US phone number might appear as `"+1.1234567890"`.
         */
        public var fax: kotlin.String? = null
        /**
         * First name of contact.
         */
        public var firstName: kotlin.String? = null
        /**
         * Last name of contact.
         */
        public var lastName: kotlin.String? = null
        /**
         * Name of the organization for contact types other than `PERSON`.
         */
        public var organizationName: kotlin.String? = null
        /**
         * The phone number of the contact.
         *
         * Constraints: Phone number must be specified in the format "+&#91;country dialing code&#93;.&#91;number including any area code>&#93;". For example, a US phone number might appear as `"+1.1234567890"`.
         */
        public var phoneNumber: kotlin.String? = null
        /**
         * The state or province of the contact's city.
         */
        public var state: kotlin.String? = null
        /**
         * The zip or postal code of the contact's address.
         */
        public var zipCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.ContactDetail) : this() {
            this.addressLine1 = x.addressLine1
            this.addressLine2 = x.addressLine2
            this.city = x.city
            this.contactType = x.contactType
            this.countryCode = x.countryCode
            this.email = x.email
            this.extraParams = x.extraParams
            this.fax = x.fax
            this.firstName = x.firstName
            this.lastName = x.lastName
            this.organizationName = x.organizationName
            this.phoneNumber = x.phoneNumber
            this.state = x.state
            this.zipCode = x.zipCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.ContactDetail = ContactDetail(this)
    }
}
