// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



public class GetDomainSuggestionsRequest private constructor(builder: Builder) {
    /**
     * A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
     *
     * The domain name can contain only the following characters:
     * + Letters a through z. Domain names are not case sensitive.
     * + Numbers 0 through 9.
     * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
     *
     * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html).
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * If `OnlyAvailable` is `true`, Route 53 returns only domain names that are available. If `OnlyAvailable` is `false`, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call `checkDomainAvailability` for each suggestion.
     */
    public val onlyAvailable: kotlin.Boolean? = builder.onlyAvailable
    /**
     * The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.
     */
    public val suggestionCount: kotlin.Int = builder.suggestionCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDomainSuggestionsRequest(")
        append("domainName=$domainName,")
        append("onlyAvailable=$onlyAvailable,")
        append("suggestionCount=$suggestionCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (onlyAvailable?.hashCode() ?: 0)
        result = 31 * result + (suggestionCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDomainSuggestionsRequest

        if (domainName != other.domainName) return false
        if (onlyAvailable != other.onlyAvailable) return false
        if (suggestionCount != other.suggestionCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html) in the *Amazon Route 53 Developer Guide*.
         *
         * The domain name can contain only the following characters:
         * + Letters a through z. Domain names are not case sensitive.
         * + Numbers 0 through 9.
         * + Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * + Period (.) to separate the labels in the name, such as the `.` in `example.com`.
         *
         * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see [Domains that You Can Register with Amazon Route 53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html).
         */
        public var domainName: kotlin.String? = null
        /**
         * If `OnlyAvailable` is `true`, Route 53 returns only domain names that are available. If `OnlyAvailable` is `false`, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call `checkDomainAvailability` for each suggestion.
         */
        public var onlyAvailable: kotlin.Boolean? = null
        /**
         * The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.
         */
        public var suggestionCount: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsRequest) : this() {
            this.domainName = x.domainName
            this.onlyAvailable = x.onlyAvailable
            this.suggestionCount = x.suggestionCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsRequest = GetDomainSuggestionsRequest(this)
    }
}
