// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



/**
 * The ListDomains request includes the following elements.
 */
public class ListDomainsRequest private constructor(builder: Builder) {
    /**
     * A complex type that contains information about the filters applied during the `ListDomains` request. The filter conditions can include domain name and domain expiration.
     */
    public val filterConditions: List<FilterCondition>? = builder.filterConditions
    /**
     * For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional domains. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
     *
     * Constraints: The marker must match the value specified in the previous request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Number of domains to be returned.
     *
     * Default: 20
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * A complex type that contains information about the requested ordering of domains in the returned list.
     */
    public val sortCondition: aws.sdk.kotlin.services.route53domains.model.SortCondition? = builder.sortCondition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDomainsRequest(")
        append("filterConditions=$filterConditions,")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("sortCondition=$sortCondition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filterConditions?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (sortCondition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDomainsRequest

        if (filterConditions != other.filterConditions) return false
        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (sortCondition != other.sortCondition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains information about the filters applied during the `ListDomains` request. The filter conditions can include domain name and domain expiration.
         */
        public var filterConditions: List<FilterCondition>? = null
        /**
         * For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current Amazon Web Services account is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional domains. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
         *
         * Constraints: The marker must match the value specified in the previous request.
         */
        public var marker: kotlin.String? = null
        /**
         * Number of domains to be returned.
         *
         * Default: 20
         */
        public var maxItems: kotlin.Int? = null
        /**
         * A complex type that contains information about the requested ordering of domains in the returned list.
         */
        public var sortCondition: aws.sdk.kotlin.services.route53domains.model.SortCondition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest) : this() {
            this.filterConditions = x.filterConditions
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.sortCondition = x.sortCondition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest = ListDomainsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.route53domains.model.SortCondition] inside the given [block]
         */
        public fun sortCondition(block: aws.sdk.kotlin.services.route53domains.model.SortCondition.Builder.() -> kotlin.Unit) {
            this.sortCondition = aws.sdk.kotlin.services.route53domains.model.SortCondition.invoke(block)
        }
    }
}
