// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.model



public class ListPricesRequest private constructor(builder: Builder) {
    /**
     * For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional prices. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
     *
     * Used only for all TLDs. If you specify a TLD, don't specify a `Marker`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * Number of `Prices` to be returned.
     *
     * Used only for all TLDs. If you specify a TLD, don't specify a `MaxItems`.
     */
    public val maxItems: kotlin.Int? = builder.maxItems
    /**
     * The TLD for which you want to receive the pricing information. For example. `.net`.
     *
     * If a `Tld` value is not provided, a list of prices for all TLDs supported by Route 53 is returned.
     */
    public val tld: kotlin.String? = builder.tld

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53domains.model.ListPricesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPricesRequest(")
        append("marker=$marker,")
        append("maxItems=$maxItems,")
        append("tld=$tld)")
    }

    override fun hashCode(): kotlin.Int {
        var result = marker?.hashCode() ?: 0
        result = 31 * result + (maxItems ?: 0)
        result = 31 * result + (tld?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPricesRequest

        if (marker != other.marker) return false
        if (maxItems != other.maxItems) return false
        if (tld != other.tld) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53domains.model.ListPricesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For an initial request for a list of prices, omit this element. If the number of prices that are not yet complete is greater than the value that you specified for `MaxItems`, you can use `Marker` to return additional prices. Get the value of `NextPageMarker` from the previous response, and submit another request that includes the value of `NextPageMarker` in the `Marker` element.
         *
         * Used only for all TLDs. If you specify a TLD, don't specify a `Marker`.
         */
        public var marker: kotlin.String? = null
        /**
         * Number of `Prices` to be returned.
         *
         * Used only for all TLDs. If you specify a TLD, don't specify a `MaxItems`.
         */
        public var maxItems: kotlin.Int? = null
        /**
         * The TLD for which you want to receive the pricing information. For example. `.net`.
         *
         * If a `Tld` value is not provided, a list of prices for all TLDs supported by Route 53 is returned.
         */
        public var tld: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53domains.model.ListPricesRequest) : this() {
            this.marker = x.marker
            this.maxItems = x.maxItems
            this.tld = x.tld
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53domains.model.ListPricesRequest = ListPricesRequest(this)
    }
}
