// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.paginators

import aws.sdk.kotlin.services.route53domains.Route53DomainsClient
import aws.sdk.kotlin.services.route53domains.model.BillingRecord
import aws.sdk.kotlin.services.route53domains.model.DomainPrice
import aws.sdk.kotlin.services.route53domains.model.DomainSummary
import aws.sdk.kotlin.services.route53domains.model.ListDomainsRequest
import aws.sdk.kotlin.services.route53domains.model.ListDomainsResponse
import aws.sdk.kotlin.services.route53domains.model.ListOperationsRequest
import aws.sdk.kotlin.services.route53domains.model.ListOperationsResponse
import aws.sdk.kotlin.services.route53domains.model.ListPricesRequest
import aws.sdk.kotlin.services.route53domains.model.ListPricesResponse
import aws.sdk.kotlin.services.route53domains.model.OperationSummary
import aws.sdk.kotlin.services.route53domains.model.ViewBillingRequest
import aws.sdk.kotlin.services.route53domains.model.ViewBillingResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun Route53DomainsClient.listDomainsPaginated(initialRequest: ListDomainsRequest): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            isFirstPage = false
            cursor = result.nextPageMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun Route53DomainsClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainsPaginated]
 * to access the nested member [DomainSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainSummary]
 */
@JvmName("listDomainsResponseDomainSummary")
public fun Flow<ListDomainsResponse>.domains(): Flow<DomainSummary> =
    transform() { response ->
        response.domains?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun Route53DomainsClient.listOperationsPaginated(initialRequest: ListOperationsRequest): Flow<ListOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listOperationsPaginated.listOperations(req)
            isFirstPage = false
            cursor = result.nextPageMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun Route53DomainsClient.listOperationsPaginated(block: ListOperationsRequest.Builder.() -> Unit): Flow<ListOperationsResponse> =
    listOperationsPaginated(ListOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOperationsPaginated]
 * to access the nested member [OperationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OperationSummary]
 */
@JvmName("listOperationsResponseOperationSummary")
public fun Flow<ListOperationsResponse>.operations(): Flow<OperationSummary> =
    transform() { response ->
        response.operations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPricesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPricesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricesResponse]
 */
public fun Route53DomainsClient.listPricesPaginated(initialRequest: ListPricesRequest): Flow<ListPricesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@listPricesPaginated.listPrices(req)
            isFirstPage = false
            cursor = result.nextPageMarker
            emit(result)
        }
    }

/**
 * Paginate over [ListPricesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPricesResponse]
 */
public fun Route53DomainsClient.listPricesPaginated(block: ListPricesRequest.Builder.() -> Unit): Flow<ListPricesResponse> =
    listPricesPaginated(ListPricesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPricesPaginated]
 * to access the nested member [DomainPrice]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainPrice]
 */
@JvmName("listPricesResponseDomainPrice")
public fun Flow<ListPricesResponse>.prices(): Flow<DomainPrice> =
    transform() { response ->
        response.prices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ViewBillingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ViewBillingRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ViewBillingResponse]
 */
public fun Route53DomainsClient.viewBillingPaginated(initialRequest: ViewBillingRequest): Flow<ViewBillingResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@viewBillingPaginated.viewBilling(req)
            isFirstPage = false
            cursor = result.nextPageMarker
            emit(result)
        }
    }

/**
 * Paginate over [ViewBillingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ViewBillingResponse]
 */
public fun Route53DomainsClient.viewBillingPaginated(block: ViewBillingRequest.Builder.() -> Unit): Flow<ViewBillingResponse> =
    viewBillingPaginated(ViewBillingRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [viewBillingPaginated]
 * to access the nested member [BillingRecord]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BillingRecord]
 */
@JvmName("viewBillingResponseBillingRecord")
public fun Flow<ViewBillingResponse>.billingRecords(): Flow<BillingRecord> =
    transform() { response ->
        response.billingRecords?.forEach {
            emit(it)
        }
    }
