// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.EnableDomainAutoRenewResponse
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class EnableDomainAutoRenewOperationDeserializer: HttpDeserialize<EnableDomainAutoRenewResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EnableDomainAutoRenewResponse {
        if (!response.status.isSuccess()) {
            throwEnableDomainAutoRenewError(context, response)
        }
        val builder = EnableDomainAutoRenewResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwEnableDomainAutoRenewError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "TLDRulesViolation" -> TldRulesViolationDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedTLD" -> UnsupportedTldDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
