// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.DomainSuggestion
import aws.sdk.kotlin.services.route53domains.model.GetDomainSuggestionsResponse
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDomainSuggestionsOperationDeserializer: HttpDeserialize<GetDomainSuggestionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDomainSuggestionsResponse {
        if (!response.status.isSuccess()) {
            throwGetDomainSuggestionsError(context, response)
        }
        val builder = GetDomainSuggestionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDomainSuggestionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDomainSuggestionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedTLD" -> UnsupportedTldDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDomainSuggestionsOperationBody(builder: GetDomainSuggestionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SUGGESTIONSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SuggestionsList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUGGESTIONSLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUGGESTIONSLIST_DESCRIPTOR.index -> builder.suggestionsList =
                    deserializer.deserializeList(SUGGESTIONSLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<DomainSuggestion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDomainSuggestionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
