// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.RetrieveDomainAuthCodeResponse
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RetrieveDomainAuthCodeOperationDeserializer: HttpDeserialize<RetrieveDomainAuthCodeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RetrieveDomainAuthCodeResponse {
        if (!response.status.isSuccess()) {
            throwRetrieveDomainAuthCodeError(context, response)
        }
        val builder = RetrieveDomainAuthCodeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRetrieveDomainAuthCodeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRetrieveDomainAuthCodeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedTLD" -> UnsupportedTldDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRetrieveDomainAuthCodeOperationBody(builder: RetrieveDomainAuthCodeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHCODE_DESCRIPTOR.index -> builder.authCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
