// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53domains.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53domains.model.BillingRecord
import aws.sdk.kotlin.services.route53domains.model.Route53DomainsException
import aws.sdk.kotlin.services.route53domains.model.ViewBillingResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ViewBillingOperationDeserializer: HttpDeserialize<ViewBillingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ViewBillingResponse {
        if (!response.status.isSuccess()) {
            throwViewBillingError(context, response)
        }
        val builder = ViewBillingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeViewBillingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwViewBillingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53DomainsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        else -> Route53DomainsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeViewBillingOperationBody(builder: ViewBillingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BILLINGRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BillingRecords"))
    val NEXTPAGEMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextPageMarker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BILLINGRECORDS_DESCRIPTOR)
        field(NEXTPAGEMARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BILLINGRECORDS_DESCRIPTOR.index -> builder.billingRecords =
                    deserializer.deserializeList(BILLINGRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<BillingRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBillingRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGEMARKER_DESCRIPTOR.index -> builder.nextPageMarker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
