// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycluster.model



public class UpdateRoutingControlStateRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
     */
    public val routingControlArn: kotlin.String? = builder.routingControlArn
    /**
     * The state of the routing control. You can set the value to be On or Off.
     */
    public val routingControlState: aws.sdk.kotlin.services.route53recoverycluster.model.RoutingControlState? = builder.routingControlState
    /**
     * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the state of a routing control. You can override one safety rule or multiple safety rules by including one or more ARNs, separated by commas.
     *
     * For more information, see [ Override safety rules to reroute traffic](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
     */
    public val safetyRulesToOverride: List<String>? = builder.safetyRulesToOverride

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.route53recoverycluster.model.UpdateRoutingControlStateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRoutingControlStateRequest(")
        append("routingControlArn=$routingControlArn,")
        append("routingControlState=$routingControlState,")
        append("safetyRulesToOverride=$safetyRulesToOverride)")
    }

    override fun hashCode(): kotlin.Int {
        var result = routingControlArn?.hashCode() ?: 0
        result = 31 * result + (routingControlState?.hashCode() ?: 0)
        result = 31 * result + (safetyRulesToOverride?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRoutingControlStateRequest

        if (routingControlArn != other.routingControlArn) return false
        if (routingControlState != other.routingControlState) return false
        if (safetyRulesToOverride != other.safetyRulesToOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.route53recoverycluster.model.UpdateRoutingControlStateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the routing control that you want to update the state for.
         */
        public var routingControlArn: kotlin.String? = null
        /**
         * The state of the routing control. You can set the value to be On or Off.
         */
        public var routingControlState: aws.sdk.kotlin.services.route53recoverycluster.model.RoutingControlState? = null
        /**
         * The Amazon Resource Names (ARNs) for the safety rules that you want to override when you're updating the state of a routing control. You can override one safety rule or multiple safety rules by including one or more ARNs, separated by commas.
         *
         * For more information, see [ Override safety rules to reroute traffic](https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html) in the Amazon Route 53 Application Recovery Controller Developer Guide.
         */
        public var safetyRulesToOverride: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.route53recoverycluster.model.UpdateRoutingControlStateRequest) : this() {
            this.routingControlArn = x.routingControlArn
            this.routingControlState = x.routingControlState
            this.safetyRulesToOverride = x.safetyRulesToOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.route53recoverycluster.model.UpdateRoutingControlStateRequest = UpdateRoutingControlStateRequest(this)
    }
}
