// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycluster.paginators

import aws.sdk.kotlin.services.route53recoverycluster.Route53RecoveryClusterClient
import aws.sdk.kotlin.services.route53recoverycluster.model.ListRoutingControlsRequest
import aws.sdk.kotlin.services.route53recoverycluster.model.ListRoutingControlsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutingControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryClusterClient.listRoutingControlsPaginated(initialRequest: ListRoutingControlsRequest): Flow<ListRoutingControlsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutingControlsPaginated.listRoutingControls(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutingControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutingControlsResponse]
 */
public fun Route53RecoveryClusterClient.listRoutingControlsPaginated(block: ListRoutingControlsRequest.Builder.() -> Unit): Flow<ListRoutingControlsResponse> =
    listRoutingControlsPaginated(ListRoutingControlsRequest.Builder().apply(block).build())
