// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.route53recoverycluster.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.route53recoverycluster.model.GetRoutingControlStateResponse
import aws.sdk.kotlin.services.route53recoverycluster.model.Route53RecoveryClusterException
import aws.sdk.kotlin.services.route53recoverycluster.model.RoutingControlState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRoutingControlStateOperationDeserializer: HttpDeserialize<GetRoutingControlStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRoutingControlStateResponse {
        if (!response.status.isSuccess()) {
            throwGetRoutingControlStateError(context, response)
        }
        val builder = GetRoutingControlStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRoutingControlStateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRoutingControlStateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Route53RecoveryClusterException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "EndpointTemporarilyUnavailableException" -> EndpointTemporarilyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Route53RecoveryClusterException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRoutingControlStateOperationBody(builder: GetRoutingControlStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROUTINGCONTROLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoutingControlArn"))
    val ROUTINGCONTROLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoutingControlName"))
    val ROUTINGCONTROLSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoutingControlState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROUTINGCONTROLARN_DESCRIPTOR)
        field(ROUTINGCONTROLNAME_DESCRIPTOR)
        field(ROUTINGCONTROLSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROUTINGCONTROLARN_DESCRIPTOR.index -> builder.routingControlArn = deserializeString()
                ROUTINGCONTROLNAME_DESCRIPTOR.index -> builder.routingControlName = deserializeString()
                ROUTINGCONTROLSTATE_DESCRIPTOR.index -> builder.routingControlState = deserializeString().let { RoutingControlState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
